/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.characters;

import com.robertx22.mine_and_slash.capability.entity.CooldownsData;
import com.robertx22.mine_and_slash.characters.CharacterData;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.WorldUtils;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class CharStorageData {
    public int current = 0;
    public HashMap<Integer, CharacterData> map = new HashMap();

    public void load(int num, Player p) {
        CharacterData data = this.map.get(num);
        if (data != null) {
            this.map.put(this.current, CharacterData.from(p));
            data.load(p);
            this.current = num;
        }
    }

    public CharacterData getCurrent() {
        return this.map.getOrDefault(this.current, new CharacterData());
    }

    public boolean canChangeCharactersRightNow(Player p) {
        if (Load.Unit((Entity)p).getCooldowns().isOnCooldown(CooldownsData.IN_COMBAT)) {
            p.m_213846_((Component)Chats.CANT_CHANGE_CHAR_IN_COMBAT.locName().m_130940_(ChatFormatting.RED));
            return false;
        }
        if (WorldUtils.isMapWorldClass(p.m_9236_(), p.m_20183_())) {
            p.m_213846_((Component)Chats.CANT_CHANGE_CHAR_IN_MAP.locName().m_130940_(ChatFormatting.RED));
            return false;
        }
        return true;
    }

    public int tryAddNewCharacter(Player p, String name) {
        if (!this.canChangeCharactersRightNow(p)) {
            return -1;
        }
        if (!this.nameIsValid(p, name)) {
            p.m_213846_((Component)Chats.CREATE_ERROR_NAME.locName().m_130940_(ChatFormatting.RED));
            return -1;
        }
        int amount = this.getAllCharacters().size();
        if (amount < (Integer)ServerContainer.get().MAX_CHARACTERS.get()) {
            CharacterData data = new CharacterData();
            if (this.map.get(this.current) == null) {
                data = CharacterData.from(p);
            }
            data.name = name;
            for (int i = 0; i < (Integer)ServerContainer.get().MAX_CHARACTERS.get(); ++i) {
                if (this.map.get(i) != null) continue;
                this.map.put(i, data);
                return i;
            }
        } else {
            p.m_213846_((Component)Chats.CREATE_ERROR_CHAR_LIMIT.locName().m_130940_(ChatFormatting.RED));
        }
        return -1;
    }

    public boolean nameIsValid(Player p, String name) {
        if (name.isEmpty()) {
            p.m_213846_((Component)Chats.NAME_EMPTY.locName().m_130940_(ChatFormatting.RED));
            return false;
        }
        if (this.getAllCharacters().stream().anyMatch(x -> x.name.equals(name))) {
            p.m_213846_((Component)Chats.NAME_SAME.locName().m_130940_(ChatFormatting.RED));
            return false;
        }
        if (name.length() > 20) {
            p.m_213846_((Component)Chats.NAME_TOO_LONG.locName().m_130940_(ChatFormatting.RED));
            return false;
        }
        return true;
    }

    public List<CharacterData> getAllCharacters() {
        return this.map.values().stream().filter(x -> x != null).collect(Collectors.toList());
    }
}

