/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.world;

import com.robertx22.dungeon_realm.main.DungeonMain;
import com.robertx22.library_of_exile.components.ICap;
import com.robertx22.library_of_exile.dimension.MapDataFinder;
import com.robertx22.library_of_exile.dimension.MapDimensionInfo;
import com.robertx22.library_of_exile.utils.LoadSave;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.maps.MnsMapDataHolder;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorldData
implements ICap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("mmorpg", "world");
    public static Capability<WorldData> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<WorldData>(){});
    final transient LazyOptional<WorldData> supp = LazyOptional.of(() -> this);
    private static final String MAP = "mapdata";
    transient Level level;
    public MnsMapDataHolder map = new MnsMapDataHolder();
    public static MapDataFinder<MapData> DATA_GETTER = new MapDataFinder<MapData>(){

        public MapData getData(MapDataFinder.Pos pos) {
            return (MapData)WorldData.get((Level)pos.level).map.getData(this.getInfo().structure, pos.pos);
        }

        public MapDimensionInfo getInfo() {
            return DungeonMain.MAP;
        }
    };

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == INSTANCE) {
            return this.supp.cast();
        }
        return LazyOptional.empty();
    }

    public static WorldData get(Level level) {
        if (level.f_46443_) {
            return new WorldData(level);
        }
        return (WorldData)level.m_7654_().m_129783_().getCapability(INSTANCE).orElse((Object)new WorldData(level));
    }

    public WorldData(Level level) {
        this.level = level;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        LoadSave.Save((Object)((Object)this.map), (CompoundTag)nbt, (String)MAP);
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.map = WorldData.loadOrBlank(MnsMapDataHolder.class, new MnsMapDataHolder(), nbt, MAP, new MnsMapDataHolder());
    }

    public static <OBJ> OBJ loadOrBlank(Class theclass, OBJ newobj, CompoundTag nbt, String loc, OBJ blank) {
        try {
            Object data = LoadSave.Load((Class)theclass, newobj, (CompoundTag)nbt, (String)loc);
            if (data == null) {
                return blank;
            }
            return (OBJ)data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return blank;
        }
    }

    public String getCapIdForSyncing() {
        return "world_data";
    }
}

