/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.player.helper;

import com.robertx22.mine_and_slash.capability.player.helper.GemInventoryHelper;
import com.robertx22.mine_and_slash.capability.player.helper.MyInventory;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.saveclasses.skill_gem.MaxLinks;
import com.robertx22.mine_and_slash.saveclasses.skill_gem.SkillGemData;
import com.robertx22.mine_and_slash.saveclasses.spells.SpellCastingData;
import com.robertx22.mine_and_slash.uncommon.ExplainedResultUtil;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.PlayerUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class SocketedGem {
    MyInventory inv;
    public SpellCastingData.InsertedSpell spell;
    public int skillGem = 0;

    public SocketedGem(MyInventory inv, SpellCastingData.InsertedSpell spell, int skillGem) {
        this.inv = inv;
        this.spell = spell;
        this.skillGem = skillGem;
    }

    public MaxLinks getMaxLinks(Player p) {
        if (this.getSkillData() == null) {
            return new MaxLinks(0, false, false);
        }
        return this.getSkillData().getMaxLinks(p);
    }

    public void removeSupportGemsIfTooMany(Player p) {
        if (this.getSupportDatas().stream().anyMatch(x -> x.getSupport().min_lvl > Load.Unit((Entity)p).getLevel())) {
            for (ItemStack s : this.getSupports()) {
                PlayerUtils.giveItem(s.m_41777_(), p);
                s.m_41774_(100);
            }
            p.m_213846_((Component)ExplainedResultUtil.createErrorAndReason(Chats.EQUIP_SUPP_ERROR, Chats.TOO_LOW_LEVEL));
        }
        if (this.getSupportDatas().size() > this.getMaxLinks((Player)p).links) {
            for (ItemStack s : this.getSupports()) {
                PlayerUtils.giveItem(s.m_41777_(), p);
                s.m_41774_(100);
            }
            p.m_213846_((Component)ExplainedResultUtil.createErrorAndReason(Chats.EQUIP_SUPP_ERROR, Chats.CANT_EQUIP_THAT_MANY_SUPPORTS));
        }
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        boolean toomany = false;
        for (SkillGemData data : this.getSupportDatas()) {
            if (data.getSupport() == null) continue;
            map.put(data.getSupport().id, map.getOrDefault(data.getSupport().id, 0) + 1);
            if ((Integer)map.get(data.getSupport().id) > 1) {
                toomany = true;
                break;
            }
            if (!data.getSupport().isOneOfAKind()) continue;
            String id = data.getSupport().one_of_a_kind;
            map.put(id, map.getOrDefault(id, 0) + 1);
            if ((Integer)map.get(id) <= 1) continue;
            toomany = true;
            break;
        }
        if (toomany) {
            for (ItemStack s : this.getSupports()) {
                PlayerUtils.giveItem(s.m_41777_(), p);
                s.m_41774_(100);
                p.m_213846_((Component)Chats.CANT_USE_MULTIPLE_SAME_SUPPORTS.locName());
            }
        }
    }

    public Spell getSpell() {
        SkillGemData data = this.getSkillData();
        if (data != null) {
            return data.getSpell();
        }
        return null;
    }

    public SkillGemData getSkillData() {
        return this.spell.getData();
    }

    public List<ItemStack> getSupports() {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 1 + this.skillGem; i < this.skillGem + GemInventoryHelper.SUPPORT_GEMS_PER_SKILL + 1; ++i) {
            list.add(this.inv.m_8020_(i));
        }
        return list;
    }

    public List<SkillGemData> getSupportDatas() {
        ArrayList<SkillGemData> list = new ArrayList<SkillGemData>();
        for (ItemStack s : this.getSupports()) {
            SkillGemData d = (SkillGemData)StackSaving.SKILL_GEM.loadFrom(s);
            if (d == null || d.getSupport() == null) continue;
            list.add(d);
        }
        return list;
    }

    public float getManaCostMulti() {
        float multi = 1.0f;
        for (SkillGemData data : this.getSupportDatas()) {
            multi *= data.getSupport().manaMulti;
        }
        return multi;
    }
}

