/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.player.data;

import com.robertx22.library_of_exile.util.ExplainedResult;
import com.robertx22.mine_and_slash.database.data.game_balance_config.PlayerPointsType;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import java.util.HashMap;
import net.minecraft.network.chat.Component;

public class PlayerPointsData {
    private HashMap<PlayerPointsType, SingleData> map = new HashMap();

    public SingleData get(PlayerPointsType type) {
        if (!this.map.containsKey((Object)type)) {
            SingleData d = new SingleData();
            d.type = type;
            this.map.put(type, d);
        }
        return this.map.get((Object)type);
    }

    public class SingleData {
        public PlayerPointsType type = PlayerPointsType.TALENTS;
        private int bonus_points = 0;
        private int cheat_points = 0;
        public int reset_points = 0;

        public int getBonusPoints() {
            return this.bonus_points;
        }

        public int getBonusCheatPoints() {
            return this.cheat_points;
        }

        public void resetBonusPoints() {
            this.bonus_points = 0;
            this.cheat_points = 0;
        }

        public ExplainedResult giveBonusPoints(int num) {
            this.bonus_points += num;
            if (this.bonus_points > this.type.getConfig().max_bonus_points) {
                return ExplainedResult.failure((Component)Chats.FAILED_TO_AWARD_POINTS.locName(this.type.word().locName(), this.type.getConfig().max_bonus_points));
            }
            return ExplainedResult.success((Component)Chats.AWARDED_POINTS.locName(num, this.type.word().locName()));
        }

        public ExplainedResult giveCheatPoints(int num) {
            this.cheat_points += num;
            return ExplainedResult.success((Component)Chats.AWARDED_POINTS.locName(num, this.type.word().locName()));
        }
    }
}

