/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.player;

import com.robertx22.library_of_exile.components.ICap;
import com.robertx22.mine_and_slash.capability.player.data.Backpacks;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PlayerBackpackData
implements ICap {
    public static final ResourceLocation RESOURCE = new ResourceLocation("mmorpg", "backpacks");
    public static Capability<PlayerBackpackData> INSTANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerBackpackData>(){});
    final transient LazyOptional<PlayerBackpackData> supp = LazyOptional.of(() -> this);
    transient Player player;
    private Backpacks data;

    public static PlayerBackpackData get(LivingEntity entity) {
        return (PlayerBackpackData)entity.getCapability(INSTANCE).orElse(null);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == INSTANCE) {
            return this.supp.cast();
        }
        return LazyOptional.empty();
    }

    public PlayerBackpackData(Player player) {
        this.player = player;
        this.data = new Backpacks(player);
    }

    public Backpacks getBackpacks() {
        return this.data;
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        for (Backpacks.BackpackType type : Backpacks.BackpackType.values()) {
            try {
                nbt.m_128365_(type.id, (Tag)this.data.getInv(type).m_7927_());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        for (Backpacks.BackpackType type : Backpacks.BackpackType.values()) {
            try {
                if (!nbt.m_128441_(type.id)) continue;
                this.data.getInv(type).m_7797_(nbt.m_128437_(type.id, 10));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void syncToClient(Player player) {
    }

    public String getCapIdForSyncing() {
        return "backpack_data";
    }
}

