/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.entity;

import com.robertx22.mine_and_slash.aoe_data.database.ailments.Ailment;
import com.robertx22.mine_and_slash.aoe_data.database.ailments.AilmentSpeed;
import com.robertx22.mine_and_slash.aoe_data.database.ailments.Ailments;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AilmentDuration;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AilmentEffectStat;
import com.robertx22.mine_and_slash.database.data.stats.types.ailment.AilmentResistance;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.saveclasses.unit.StatData;
import com.robertx22.mine_and_slash.uncommon.MathHelper;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.effectdatas.DamageEvent;
import com.robertx22.mine_and_slash.uncommon.effectdatas.EventBuilder;
import com.robertx22.mine_and_slash.uncommon.effectdatas.rework.EventData;
import com.robertx22.mine_and_slash.uncommon.enumclasses.AttackType;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import com.robertx22.mine_and_slash.uncommon.enumclasses.WeaponTypes;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class EntityAilmentData {
    public HashMap<UUID, OneData> datas = new HashMap();

    public void shatterAccumulated(LivingEntity caster, LivingEntity target, Ailment ailment, Spell spell) {
        if (!this.datas.containsKey(caster.m_20148_())) {
            this.datas.put(caster.m_20148_(), new OneData());
        }
        OneData data = this.datas.get(caster.m_20148_());
        float dmg = data.dmgMap.getOrDefault(ailment.GUID(), Float.valueOf(0.0f)).floatValue();
        data.dmgMap.put(ailment.GUID(), Float.valueOf(0.0f));
        if (dmg > 0.0f) {
            EventBuilder<DamageEvent> b = EventBuilder.ofDamage(caster, target, (int)dmg).setupDamage(AttackType.dot, WeaponTypes.none, PlayStyle.INT).set(x -> {
                x.calcSourceEffects = false;
                x.calcTargetEffects = false;
                x.setElement(ailment.element);
                x.setisAilmentDamage(ailment);
                if (spell != null) {
                    x.data.setString(EventData.WEAPON_TYPE, spell.getWeapon((LivingEntity)caster).id);
                    x.data.setString(EventData.SPELL, spell.GUID());
                }
            });
            DamageEvent ev = b.build();
            ev.Activate();
        }
    }

    public void onAilmentCausingDamage(LivingEntity caster, LivingEntity target, Ailment ailment, float dmg) {
        float freeze;
        if (!this.datas.containsKey(caster.m_20148_())) {
            this.datas.put(caster.m_20148_(), new OneData());
        }
        OneData data = this.datas.get(caster.m_20148_());
        AilmentDuration dur = new AilmentDuration(ailment);
        AilmentResistance res = new AilmentResistance(ailment);
        AilmentEffectStat eff = new AilmentEffectStat(ailment);
        float speed = Load.Unit((Entity)caster).getUnit().getCalculatedStat(AilmentSpeed.INSTANCE).getMultiplier();
        dmg *= ailment.damageEffectivenessMulti;
        dmg *= Load.Unit((Entity)caster).getUnit().getCalculatedStat(eff).getMultiplier();
        StatData resist = Load.Unit((Entity)target).getUnit().getCalculatedStat(res);
        float resmulti = resist.getReverseMultiplier();
        dmg *= resmulti;
        if (ailment.isDot) {
            float secmulti = 1.0f / ((float)ailment.durationTicks / 20.0f);
            dmg *= secmulti;
        }
        if (ailment.isDot) {
            dmg *= speed;
            int ticks = ailment.durationTicks;
            float stat = Load.Unit((Entity)caster).getUnit().getCalculatedStat(AilmentSpeed.INSTANCE).getMultiplier();
            ticks = (int)((float)ticks / stat);
            if ((ticks = (int)((float)ticks * Load.Unit((Entity)caster).getUnit().getCalculatedStat(dur).getMultiplier())) < 21) {
                ticks = 21;
            }
            if (!data.dotMap.containsKey(ailment.GUID())) {
                data.dotMap.put(ailment.GUID(), new ArrayList());
            }
            data.dotMap.get(ailment.GUID()).add(new DotData(ticks, dmg));
        } else {
            float strength = 0.0f;
            float max = Load.Unit((Entity)target).getUnit().healthData().getValue() + Load.Unit((Entity)target).getUnit().magicShieldData().getValue();
            float forFull = max * ailment.percentHealthRequiredForFullStrength;
            if (!data.strMap.containsKey(ailment.GUID())) {
                data.strMap.put(ailment.GUID(), Float.valueOf(0.0f));
            }
            if (!data.dmgMap.containsKey(ailment.GUID())) {
                data.dmgMap.put(ailment.GUID(), Float.valueOf(0.0f));
            }
            data.dmgMap.put(ailment.GUID(), Float.valueOf(data.dmgMap.get(ailment.GUID()).floatValue() + dmg));
            float add = dmg / forFull;
            strength = MathHelper.clamp(data.strMap.get(ailment.GUID()).floatValue() + add, 0.0f, 1.0f);
            strength *= Load.Unit((Entity)caster).getUnit().getCalculatedStat(eff).getMultiplier();
            data.strMap.put(ailment.GUID(), Float.valueOf(strength *= Load.Unit((Entity)target).getUnit().getCalculatedStat(res).getMultiplier()));
        }
        if (ailment.GUID().equals(Ailments.FREEZE.GUID()) && (freeze = data.strMap.getOrDefault(Ailments.FREEZE.GUID(), Float.valueOf(0.0f)).floatValue()) > 0.0f) {
            int max;
            int tier = Ailments.FREEZE.getSlowTier(freeze);
            if (tier > (max = Load.Unit((Entity)target).getMobRarity().max_slow_from_chill)) {
                tier = max;
            }
            if (tier > -1) {
                target.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 100, tier));
            }
        }
    }

    public void onTick(LivingEntity en) {
        for (Map.Entry<UUID, OneData> entry : this.datas.entrySet()) {
            ServerLevel serverLevel;
            Entity entity;
            UUID id;
            OneData data = entry.getValue();
            for (Map.Entry<String, List<DotData>> entry2 : data.dotMap.entrySet()) {
                for (DotData d : entry2.getValue()) {
                    d.ticks -= 1.0f;
                }
            }
            if (en.f_19797_ % 20 == 0) {
                for (Map.Entry<String, Object> entry3 : data.strMap.entrySet()) {
                    if (!(((Float)entry3.getValue()).floatValue() > 0.0f)) continue;
                    Ailment ail = (Ailment)ExileDB.Ailments().get(entry3.getKey());
                    entry3.setValue(Float.valueOf(((Float)entry3.getValue()).floatValue() - ((Float)entry3.getValue()).floatValue() * ail.percentLostEveryXSeconds));
                }
            }
            if (en.f_19797_ % 20 != 0) continue;
            if (!data.dotMap.isEmpty() && (id = entry.getKey()) != null && (entity = (serverLevel = (ServerLevel)en.m_9236_()).m_8791_(id)) instanceof LivingEntity) {
                LivingEntity caster = (LivingEntity)entity;
                for (Map.Entry<String, List<DotData>> e : data.dotMap.entrySet()) {
                    float dmg = 0.0f;
                    for (DotData d : e.getValue()) {
                        if (!(d.ticks > 0.0f)) continue;
                        dmg += d.dmg;
                    }
                    if (!(dmg > 1.0f)) continue;
                    Ailment ailment = (Ailment)ExileDB.Ailments().get(e.getKey());
                    EventBuilder.ofDamage(caster, en, dmg).setupDamage(AttackType.dot, WeaponTypes.none, PlayStyle.INT).set(x -> {
                        x.setElement(ailment.element);
                        x.setisAilmentDamage(ailment);
                        x.calcTargetEffects = false;
                        x.calcSourceEffects = false;
                    }).build().Activate();
                }
            }
            for (List list : data.dotMap.values()) {
                list.removeIf(x -> x.ticks < 1.0f);
            }
        }
        if (en.f_19797_ % 400 == 0) {
            ServerLevel s = (ServerLevel)en.m_9236_();
            this.datas.entrySet().removeIf(x -> {
                if (((OneData)x.getValue()).isEmpty()) {
                    return true;
                }
                Entity entity = s.m_8791_((UUID)x.getKey());
                return !(entity instanceof LivingEntity);
            });
        }
    }

    public static class OneData {
        public HashMap<String, List<DotData>> dotMap = new HashMap();
        public HashMap<String, Float> strMap = new HashMap();
        public HashMap<String, Float> dmgMap = new HashMap();

        public boolean isEmpty() {
            return this.dotMap.isEmpty() && this.strMap.isEmpty() && this.dmgMap.isEmpty();
        }
    }

    public class DotData {
        public float ticks;
        public float dmg;

        public DotData(int ticks, float dmg) {
            this.ticks = ticks;
            this.dmg = dmg;
        }
    }
}

