/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.capability.entity;

import com.robertx22.mine_and_slash.database.registry.ExileDB;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class CooldownsData {
    public static String IN_COMBAT = "in_combat";
    private HashMap<String, Data> map = new HashMap();

    public void tickSpellCooldowns(int ticks) {
        this.getAllSpellsOnCooldown().forEach(x -> this.tickDownCooldown((String)x, ticks));
    }

    public void tickDownCooldown(String id, int ticks) {
        if (this.map.containsKey(id)) {
            Data data = this.map.get(id);
            data.ticks -= ticks;
            if (data.ticks < 1) {
                this.map.remove(id);
            }
        }
    }

    public void onTicksPass(int ticks) {
        if (this.map.isEmpty()) {
            return;
        }
        new HashMap<String, Data>(this.map).entrySet().forEach(x -> this.tickDownCooldown((String)x.getKey(), ticks));
    }

    public List<String> getAllSpellsOnCooldown() {
        return this.map.keySet().stream().filter(x -> ExileDB.Spells().isRegistered(x)).collect(Collectors.toList());
    }

    public void setOnCooldown(String id, int ticks) {
        this.map.put(id, new Data(ticks, ticks));
    }

    public int getCooldownTicks(String id) {
        return this.map.getOrDefault((Object)id, (Data)new Data((int)0, (int)0)).ticks;
    }

    public int getNeededTicks(String id) {
        return this.map.getOrDefault((Object)id, (Data)new Data((int)0, (int)0)).need;
    }

    public boolean isOnCooldown(String id) {
        return this.getCooldownTicks(id) > 0;
    }

    public boolean runIfNoCooldownAndSet(String id, int cdticks, Runnable run) {
        if (!this.isOnCooldown(id)) {
            run.run();
            this.setOnCooldown(id, cdticks);
            return true;
        }
        return false;
    }

    public static class Data {
        public int ticks = 0;
        public int need = 0;

        public Data() {
        }

        public Data(int ticks, int need) {
            this.ticks = ticks;
            this.need = need;
        }
    }
}

