/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.database.spells.schools;

import com.robertx22.library_of_exile.registry.ExileRegistryInit;
import com.robertx22.mine_and_slash.a_libraries.player_animations.AnimationHolder;
import com.robertx22.mine_and_slash.a_libraries.player_animations.SpellAnimations;
import com.robertx22.mine_and_slash.aoe_data.database.exile_effects.adders.ModEffects;
import com.robertx22.mine_and_slash.aoe_data.database.spells.PartBuilder;
import com.robertx22.mine_and_slash.aoe_data.database.spells.SpellBuilder;
import com.robertx22.mine_and_slash.aoe_data.database.spells.SpellCalcs;
import com.robertx22.mine_and_slash.aoe_data.database.stats.base.EffectCtx;
import com.robertx22.mine_and_slash.database.data.spells.SetAdd;
import com.robertx22.mine_and_slash.database.data.spells.components.SpellConfiguration;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.AggroAction;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.ExileEffectAction;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.SpellAction;
import com.robertx22.mine_and_slash.database.data.spells.components.actions.vanity.ParticleMotion;
import com.robertx22.mine_and_slash.database.data.spells.components.selectors.TargetSelector;
import com.robertx22.mine_and_slash.database.data.spells.map_fields.MapField;
import com.robertx22.mine_and_slash.database.data.spells.spell_classes.CastingWeapon;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashEntities;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashPotions;
import com.robertx22.mine_and_slash.mmorpg.registers.common.SlashSounds;
import com.robertx22.mine_and_slash.tags.all.SpellTags;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.enumclasses.PlayStyle;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.AllyOrEnemy;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.EntityFinder;
import java.util.Arrays;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Items;

public class HolySpells
implements ExileRegistryInit {
    public static String HEALING_AURA_ID = "healing_aura";
    public static String WISH = "wish";
    public static String UNDYING_WILL = "undying_will";
    public static String BANISH = "banish";
    public static String INSPIRATION = "awaken_mana";
    public static String SHOOTING_STAR = "shooting_star";
    public static String CHARGE_ID = "charge";
    public static String GONG_STRIKE_ID = "gong_strike";
    public static String WHIRLWIND = "whirlwind";
    public static String TAUNT = "taunt";
    public static String SHOUT_WARN = "shout_warn";
    public static String PULL = "pull";
    public static String HOLY_MISSILES = "holy_missiles";
    public static String HYMN_OF_VALOR = "song_of_valor";
    public static String HYMN_OF_PERSERVANCE = "song_of_perseverance";
    public static String HYMN_OF_VIGOR = "song_of_vigor";

    public void registerAll() {
        HolySpells.song(HYMN_OF_VALOR, "Hymn of Valor", ModEffects.VALOR);
        HolySpells.song(HYMN_OF_PERSERVANCE, "Hymn of Perseverance", ModEffects.PERSEVERANCE);
        HolySpells.song(HYMN_OF_VIGOR, "Hymn of Vigor", ModEffects.VIGOR);
        SpellBuilder.of(WHIRLWIND, PlayStyle.STR, SpellConfiguration.Builder.multiCast(10, 0, 100, 10).setSwingArm(), "Whirlwind", Arrays.asList(SpellTags.weapon_skill, SpellTags.area, SpellTags.damage, SpellTags.PHYSICAL)).manualDesc("Spin and continuously strike enemies around you for " + SpellCalcs.WHIRLWIND.getLocDmgTooltip(Elements.Physical)).animations(SpellAnimations.SPIN, SpellAnimations.CAST_FINISH).weaponReq(CastingWeapon.MELEE_WEAPON).onCast(PartBuilder.giveSelfEffect((MobEffect)SlashPotions.KNOCKBACK_RESISTANCE.get(), 100.0)).onCast(PartBuilder.playSound(SoundEvents.f_12317_, 1.0, 1.0)).onCast(PartBuilder.groundEdgeParticles(ParticleTypes.f_123806_, 100.0, 2.0, 0.5)).onCast(PartBuilder.groundEdgeParticles(ParticleTypes.f_123766_, 25.0, 2.0, 1.0)).onCast(PartBuilder.damageInAoe(SpellCalcs.WHIRLWIND, Elements.Physical, 1.5).addPerEntityHit(PartBuilder.groundEdgeParticles(ParticleTypes.f_123806_, 50.0, 0.5, 0.1))).levelReq(30).build();
        SpellBuilder.of(CHARGE_ID, PlayStyle.STR, SpellConfiguration.Builder.multiCast(10, 200, 60, 60), "Charge", Arrays.asList(SpellTags.area, SpellTags.damage, SpellTags.movement, SpellTags.PHYSICAL)).manualDesc("Charge in a direction, stopping upon first enemy hit to deal " + SpellCalcs.CHARGE.getLocDmgTooltip() + " " + Elements.Physical.getIconNameDmg() + " in an area.").disableCastingSlow().animations(SpellAnimations.CHARGE, SpellAnimations.TAUNT).weaponReq(CastingWeapon.MELEE_WEAPON).onCast(PartBuilder.playSound(SoundEvents.f_12652_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.SET_ADD_MOTION.create(SetAdd.ADD, 0.4, ParticleMotion.CasterLook).put(MapField.IGNORE_Y, true)).addTarget(TargetSelector.CASTER.create())).onCast(PartBuilder.groundEdgeParticles(ParticleTypes.f_123796_, 20.0, 1.0, 0.5)).onCast(PartBuilder.groundEdgeParticles(ParticleTypes.f_123813_, 1.0, 1.0, 0.5)).onCast(PartBuilder.damageInAoe(SpellCalcs.CHARGE, Elements.Physical, 1.75).addPerEntityHit(PartBuilder.playSound(SoundEvents.f_11668_, 1.0, 1.0)).addPerEntityHit(PartBuilder.groundEdgeParticles(ParticleTypes.f_123806_, 100.0, 0.5, 0.1)).addPerEntityHit(PartBuilder.groundEdgeParticles(ParticleTypes.f_123796_, 100.0, 0.5, 0.1)).addPerEntityHit(PartBuilder.cancelSpell())).levelReq(1).build();
        SpellBuilder.of(TAUNT, PlayStyle.STR, SpellConfiguration.Builder.instant(0, 600).setSwingArm(), "Taunt", Arrays.asList(SpellTags.area, SpellTags.BUFF)).manualDesc("Shout, making nearby enemies want to attack you. Generates " + SpellCalcs.TAUNT.getLocDmgTooltip() + " threat.").animations(AnimationHolder.none(), SpellAnimations.TAUNT).weaponReq(CastingWeapon.MELEE_WEAPON).onCast(PartBuilder.playSound(SoundEvents.f_12346_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.AGGRO.create(SpellCalcs.TAUNT, AggroAction.Type.AGGRO)).addTarget(TargetSelector.AOE.create(3.0, EntityFinder.SelectionType.RADIUS, AllyOrEnemy.enemies))).onCast(PartBuilder.aoeParticles(ParticleTypes.f_123796_, 20.0, 3.0)).levelReq(10).build();
        SpellBuilder.of(PULL, PlayStyle.STR, SpellConfiguration.Builder.instant(5, 1200), "Pull", Arrays.asList(SpellTags.weapon_skill, SpellTags.area, SpellTags.damage, SpellTags.PHYSICAL)).manualDesc("Pull enemies in area to you, dealing " + SpellCalcs.PULL.getLocDmgTooltip() + " " + Elements.Physical.getIconNameDmg() + " and slowing them.").animations(AnimationHolder.none(), SpellAnimations.PULL).onCast(PartBuilder.playSound(SoundEvents.f_11667_, 1.0, 1.0)).onCast(PartBuilder.justAction(SpellAction.TP_TARGET_TO_SELF.create()).addActions(SpellAction.POTION.createGive(MobEffects.f_19597_, 100.0)).addActions(SpellAction.DEAL_DAMAGE.create(SpellCalcs.PULL, Elements.Physical)).addActions(SpellAction.EXILE_EFFECT.create(ModEffects.STUN.resourcePath, ExileEffectAction.GiveOrTake.GIVE_STACKS, 40.0)).addTarget(TargetSelector.AOE.create(8.0, EntityFinder.SelectionType.RADIUS, AllyOrEnemy.enemies))).onCast(PartBuilder.groundEdgeParticles(ParticleTypes.f_123797_, 100.0, 6.0, 0.1)).levelReq(20).build();
        SpellBuilder.of(GONG_STRIKE_ID, PlayStyle.STR, SpellConfiguration.Builder.instant(8, 200).setSwingArm(), "Gong Strike", Arrays.asList(SpellTags.weapon_skill, SpellTags.area, SpellTags.damage, SpellTags.PHYSICAL)).manualDesc("Bash enemies around you for " + SpellCalcs.GONG_STRIKE.getLocDmgTooltip(Elements.Physical)).singleAnimation(SpellAnimations.TAUNT).weaponReq(CastingWeapon.MELEE_WEAPON).onCast(PartBuilder.playSound(SoundEvents.f_11669_, 1.0, 1.0)).onCast(PartBuilder.playSound(SoundEvents.f_11913_, 1.0, 1.0)).onCast(PartBuilder.damageInFront(SpellCalcs.GONG_STRIKE, Elements.Physical, 2.0, 3.0)).onCast(PartBuilder.addExileEffectToEnemiesInFront(ModEffects.STUN.resourcePath, 2.0, 2.0, 60.0)).onCast(PartBuilder.groundEdgeParticles(ParticleTypes.f_123796_, 300.0, 2.0, 0.1)).onCast(PartBuilder.groundEdgeParticles(ParticleTypes.f_123813_, 5.0, 2.0, 0.1)).levelReq(1).build();
        SpellBuilder.of(UNDYING_WILL, PlayStyle.STR, SpellConfiguration.Builder.instant(7, 1200), "Undying Will", Arrays.asList(SpellTags.BUFF)).manualDesc("Gives buff to self.").weaponReq(CastingWeapon.ANY_WEAPON).onCast(PartBuilder.playSound(SoundEvents.f_12363_, 1.0, 1.0)).onCast(PartBuilder.giveSelfExileEffect(ModEffects.UNDYING_WILL, (Double)200.0)).onCast(PartBuilder.aoeParticles(ParticleTypes.f_123808_, 50.0, 1.0)).onCast(PartBuilder.aoeParticles(ParticleTypes.f_123809_, 50.0, 1.0)).levelReq(30).build();
        SpellBuilder.of(INSPIRATION, PlayStyle.INT, SpellConfiguration.Builder.instant(0, 6000), "Inspiration", Arrays.asList(SpellTags.heal)).manualDesc("Restores " + SpellCalcs.AWAKEN_MANA.getLocDmgTooltip() + " mana.").weaponReq(CastingWeapon.ANY_WEAPON).onCast(PartBuilder.playSound(SoundEvents.f_11757_, 1.0, 1.0)).onCast(PartBuilder.aoeParticles(ParticleTypes.f_123771_, 40.0, 1.5)).onCast(PartBuilder.aoeParticles(ParticleTypes.f_123750_, 12.0, 1.5)).onCast(PartBuilder.restoreManaToCaster(SpellCalcs.AWAKEN_MANA)).levelReq(10).build();
        SpellBuilder.of(SHOOTING_STAR, PlayStyle.INT, SpellConfiguration.Builder.instant(10, 20).setSwingArm().setTracksNonSelfAllies().setTrackingRadius(5).applyCastSpeedToCooldown(), "Shooting Star", Arrays.asList(SpellTags.projectile, SpellTags.heal)).manualDesc("Shoots a star that heals allies for " + SpellCalcs.SHOOTING_STAR.getLocDmgTooltip() + " health on hit.").weaponReq(CastingWeapon.MAGE_WEAPON).onCast(PartBuilder.playSound(SoundEvents.f_11736_, 1.0, 1.7)).onCast(PartBuilder.justAction(SpellAction.SUMMON_PROJECTILE.create(Items.f_42686_, 1.0, 1.0, (EntityType)SlashEntities.SIMPLE_PROJECTILE.get(), 20.0, false).put(MapField.HITS_ALLIES, true).put(MapField.TRACKS_ENEMIES, true))).onTick(PartBuilder.aoeParticles(ParticleTypes.f_123797_, 3.0, 0.5).tick(1.0)).onTick(PartBuilder.aoeParticles(ParticleTypes.f_123745_, 5.0, 0.5).tick(1.0)).onTick(PartBuilder.aoeParticles(ParticleTypes.f_123809_, 1.0, 0.7).tick(1.0)).onExpire(PartBuilder.healInAoe(SpellCalcs.SHOOTING_STAR, 2.0)).onExpire(PartBuilder.aoeParticles(ParticleTypes.f_123745_, 10.0, 1.0)).levelReq(10).build();
        SpellBuilder.of(HEALING_AURA_ID, PlayStyle.INT, SpellConfiguration.Builder.multiCast(15, 600, 60, 3), "Healing Aria", Arrays.asList(SpellTags.area, SpellTags.heal, SpellTags.song)).manualDesc("Heal allies around you for " + SpellCalcs.HEALING_AURA.getLocDmgTooltip() + " health").animations(SpellAnimations.STAFF_CAST_WAVE_LOOP, SpellAnimations.STAFF_CAST_FINISH).weaponReq(CastingWeapon.ANY_WEAPON).onCast(PartBuilder.playSound((SoundEvent)SlashSounds.BUFF.get(), 1.0, 1.0)).onCast(PartBuilder.groundParticles(ParticleTypes.f_123749_, 50.0, 2.0, 0.2)).onCast(PartBuilder.groundParticles(ParticleTypes.f_123750_, 20.0, 2.0, 0.2)).onCast(PartBuilder.healInAoe(SpellCalcs.HEALING_AURA, 4.0)).levelReq(1).build();
        SpellBuilder.of(WISH, PlayStyle.INT, SpellConfiguration.Builder.nonInstant(20, 0, 30).setChargesAndRegen(WISH, 3, 600), "Wish", Arrays.asList(SpellTags.heal)).animations(SpellAnimations.STAFF_CAST_WAVE_LOOP, SpellAnimations.STAFF_CAST_FINISH).manualDesc("Heal allies around you for " + SpellCalcs.WISH.getLocDmgTooltip() + " health").weaponReq(CastingWeapon.ANY_WEAPON).onCast(PartBuilder.playSound((SoundEvent)SlashSounds.BUFF.get(), 1.0, 1.0)).onCast(PartBuilder.groundParticles(ParticleTypes.f_123749_, 50.0, 5.0, 0.2)).onCast(PartBuilder.groundParticles(ParticleTypes.f_123750_, 50.0, 5.0, 0.2)).onCast(PartBuilder.healInAoe(SpellCalcs.WISH, 5.0)).levelReq(20).build();
    }

    static void song(String id, String name, EffectCtx effect) {
        SpellBuilder.of(id, PlayStyle.INT, SpellConfiguration.Builder.nonInstant(10, 200, 10), name, Arrays.asList(SpellTags.area, SpellTags.song, SpellTags.BUFF)).manualDesc("Give a stack of " + effect.locname + " to all allies around you.").onCast(PartBuilder.playSound(SoundEvents.f_11871_, 1.0, 1.0)).onCast(PartBuilder.aoeParticles(ParticleTypes.f_123758_, 50.0, 3.0)).onCast(PartBuilder.giveExileEffectToAlliesInRadius(10.0, effect.resourcePath, 600.0)).levelReq(10).build();
    }
}

