/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.database.ailments;

import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.mine_and_slash.aoe_data.database.ailments.Ailments;
import com.robertx22.mine_and_slash.database.registry.ExileRegistryTypes;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocDesc;
import com.robertx22.mine_and_slash.uncommon.interfaces.IAutoLocName;
import com.robertx22.mine_and_slash.uncommon.interfaces.IBaseAutoLoc;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.StringUTIL;
import java.util.function.Function;

public class Ailment
implements ExileRegistry<Ailment>,
IAutoLocName,
IAutoLocDesc {
    String id;
    public Elements element;
    public boolean isDot;
    public boolean isStrengthEffect;
    public float damageEffectivenessMulti;
    public float percentLostEveryXSeconds;
    public int durationTicks;
    public float percentHealthRequiredForFullStrength = 0.25f;
    Function<Ailment, String> desc;

    public int getDurationSeconds() {
        return this.durationTicks / 20;
    }

    public int getPercentDamage() {
        return (int)(this.damageEffectivenessMulti * 100.0f);
    }

    public Ailment(String id, Elements element, boolean isDot, boolean isStrengthEffect, float damageEffectivenessMulti, float percentLostEveryXSeconds, int durationTicks, Function<Ailment, String> desc) {
        this.id = id;
        this.isStrengthEffect = isStrengthEffect;
        this.element = element;
        this.isDot = isDot;
        this.desc = desc;
        this.damageEffectivenessMulti = damageEffectivenessMulti;
        this.percentLostEveryXSeconds = percentLostEveryXSeconds;
        this.durationTicks = durationTicks;
        Ailments.ALL.add(this);
    }

    public int getSlowTier(float multi) {
        if (multi == 0.0f) {
            return -1;
        }
        int tier = (int)((double)multi * 10.0);
        if (multi >= 1.0f) {
            tier = 50;
        }
        return tier;
    }

    public ExileRegistryType getExileRegistryType() {
        return ExileRegistryTypes.AILMENT;
    }

    public String GUID() {
        return this.id;
    }

    public int Weight() {
        return 1000;
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locNameGroup() {
        return IBaseAutoLoc.AutoLocGroup.StatusEffects;
    }

    @Override
    public String locNameLangFileGUID() {
        return "mmorpg.ailment." + this.GUID();
    }

    @Override
    public String locNameForLangFile() {
        return StringUTIL.capitalise(this.id);
    }

    @Override
    public IBaseAutoLoc.AutoLocGroup locDescGroup() {
        return IBaseAutoLoc.AutoLocGroup.StatusEffects;
    }

    @Override
    public String locDescLangFileGUID() {
        return "mmorpg.ailment.desc." + this.GUID();
    }

    @Override
    public String locDescForLangFile() {
        return this.desc.apply(this);
    }
}

