/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.aoe_data.database;

import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.stats.Stat;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.Armor;
import com.robertx22.mine_and_slash.database.data.stats.types.defense.DodgeRating;
import com.robertx22.mine_and_slash.database.data.stats.types.offense.WeaponDamage;
import com.robertx22.mine_and_slash.database.data.stats.types.resources.magic_shield.MagicShield;
import com.robertx22.mine_and_slash.uncommon.enumclasses.ModType;
import com.robertx22.mine_and_slash.uncommon.enumclasses.WeaponTypes;

public interface GearDataHelper {
    default public StatMod getStat(ArmorStat stat, ArmorSlot slot) {
        float v1min = stat.min * slot.multi;
        float v1max = stat.max * slot.multi;
        return new StatMod(v1min, v1max, stat.stat, ModType.FLAT);
    }

    default public StatMod halfStat(ArmorStat stat, ArmorSlot slot) {
        float v1min = stat.min * slot.multi * 0.5f;
        float v1max = stat.max * slot.multi * 0.5f;
        return new StatMod(v1min, v1max, stat.stat, ModType.FLAT);
    }

    default public StatMod getAttackDamageStat(WeaponTypes weapon) {
        float v1min = 2.0f;
        float v1max = 6.0f;
        return new StatMod(v1min, v1max, WeaponDamage.getInstance(), ModType.FLAT);
    }

    public static enum ArmorStat {
        ARMOR(10.0f, 15.0f, Armor.getInstance()),
        MAGIC_SHIELD(5.0f, 10.0f, MagicShield.getInstance()),
        DODGE(10.0f, 15.0f, DodgeRating.getInstance());

        public float min;
        public float max;
        public Stat stat;

        private ArmorStat(float min, float max, Stat stat) {
            this.min = min;
            this.max = max;
            this.stat = stat;
        }
    }

    public static enum ArmorSlot {
        HELMET(0.5f),
        CHEST(1.0f),
        PANTS(0.8f),
        BOOTS(0.5f);

        public float multi;

        private ArmorSlot(float multi) {
            this.multi = multi;
        }
    }
}

