/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.a_libraries.player_animations;

import com.robertx22.mine_and_slash.a_libraries.player_animations.AnimationHolder;
import com.robertx22.mine_and_slash.a_libraries.player_animations.SpellAnimations;
import com.robertx22.mine_and_slash.config.forge.ClientConfigs;
import com.robertx22.mine_and_slash.database.data.spells.components.Spell;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonConfiguration;
import dev.kosmx.playerAnim.api.firstPerson.FirstPersonMode;
import dev.kosmx.playerAnim.api.layered.IAnimation;
import dev.kosmx.playerAnim.api.layered.KeyframeAnimationPlayer;
import dev.kosmx.playerAnim.api.layered.ModifierLayer;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractFadeModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AbstractModifier;
import dev.kosmx.playerAnim.api.layered.modifier.AdjustmentModifier;
import dev.kosmx.playerAnim.api.layered.modifier.MirrorModifier;
import dev.kosmx.playerAnim.core.data.KeyframeAnimation;
import dev.kosmx.playerAnim.core.util.Ease;
import dev.kosmx.playerAnim.core.util.Vec3f;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationAccess;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationFactory;
import dev.kosmx.playerAnim.minecraftApi.PlayerAnimationRegistry;
import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class PlayerAnimations {
    public static HashMap<UUID, KeyframeAnimationPlayer> castingAnimationPlayerLookup = new HashMap();

    public static void initClient() {
        PlayerAnimationFactory.ANIMATION_DATA_FACTORY.registerFactory(SpellAnimations.ANIMATION_RESOURCE, 40, player -> {
            ModifierLayer animation = new ModifierLayer();
            animation.addModifierLast((AbstractModifier)new AdjustmentModifier(partName -> {
                switch (partName) {
                    case "rightArm": 
                    case "leftArm": {
                        return Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(player.m_146909_() * ((float)Math.PI / 180), (float)Math.PI / 180 * (player.f_20885_ - player.f_20883_), 0.0f), Vec3f.ZERO));
                    }
                }
                return Optional.empty();
            }));
            animation.addModifierLast((AbstractModifier)new MirrorModifier(){

                public boolean isEnabled() {
                    GearItemData gear = (GearItemData)StackSaving.GEARS.loadFrom(player.m_21205_());
                    return gear == null || !gear.isWeapon();
                }
            });
            return animation;
        });
    }

    public static void onSpellCast(Player player, Spell spell, CastEnum c) {
        if (!((Boolean)ClientConfigs.CLIENT.USE_SPELL_ANIMATIONS.get()).booleanValue()) {
            return;
        }
        AnimationHolder x = spell.getAnimation(c);
        if (x != null) {
            if (c == CastEnum.CAST_START) {
                PlayerAnimations.animatePlayerStart(player, x.getLocation());
            } else {
                PlayerAnimations.handleClientBoundOnCastFinished(player, x.getLocation(), spell, false);
            }
        }
    }

    private static void animatePlayerStart(Player player, ResourceLocation resourceLocation) {
        KeyframeAnimation keyframeAnimation = PlayerAnimationRegistry.getAnimation((ResourceLocation)resourceLocation);
        if (keyframeAnimation != null) {
            AnimationHolder config = SpellAnimations.MAP.getOrDefault(resourceLocation.m_135815_(), AnimationHolder.none());
            ModifierLayer animation = (ModifierLayer)PlayerAnimationAccess.getPlayerAssociatedData((AbstractClientPlayer)((AbstractClientPlayer)player)).get(SpellAnimations.ANIMATION_RESOURCE);
            if (animation != null) {
                KeyframeAnimationPlayer castingAnimationPlayer = new KeyframeAnimationPlayer(keyframeAnimation);
                castingAnimationPlayerLookup.put(player.m_20148_(), castingAnimationPlayer);
                boolean armsFlag = true;
                boolean itemsFlag = true;
                if (armsFlag || itemsFlag) {
                    castingAnimationPlayer.setFirstPersonMode(FirstPersonMode.THIRD_PERSON_MODEL);
                    castingAnimationPlayer.setFirstPersonConfiguration(new FirstPersonConfiguration(armsFlag, armsFlag, true, !config.hideOffhand));
                }
                animation.replaceAnimationWithFade(AbstractFadeModifier.standardFadeIn((int)2, (Ease)Ease.INOUTSINE), (IAnimation)castingAnimationPlayer, true);
            }
        }
    }

    public static void handleClientBoundOnCastFinished(Player player, ResourceLocation finishAnimation, Spell spell, boolean cancelled) {
        if (finishAnimation != null && !cancelled) {
            PlayerAnimations.animatePlayerStart(player, finishAnimation);
        }
    }

    public static enum CastEnum {
        CAST_START,
        CAST_FINISH;

    }
}

