/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.a_libraries.jei;

import com.robertx22.mine_and_slash.database.data.StatMod;
import com.robertx22.mine_and_slash.database.data.runewords.RunewordRecipe;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.List;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryExtension;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class RunewordExtension
implements IRecipeCategoryExtension {
    private static final int SLOT_SIZE = 18;
    private static final int LINES_GAP = 2;
    private static final int STATS_Y_GAP = 8;
    private static final int NAME_Y_POSITION = 0;
    int maximumResultItemsPerRow;
    int categoryWidth;
    int lineHeight;
    int statsY;
    int slotsY;
    int slotsTextY;
    int inputY;
    int nameY;
    int runewordsTextY;

    public RunewordExtension(int categoryWidth) {
        this.categoryWidth = categoryWidth;
        Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
        this.lineHeight = 9;
        this.nameY = 0;
        this.runewordsTextY = this.offsetLines(this.nameY, 2);
        this.inputY = this.offsetLine(this.runewordsTextY);
        this.slotsTextY = this.offsetLine(this.inputY + 18);
        this.slotsY = this.offsetLine(this.slotsTextY);
        this.statsY = this.slotsY + 8;
        this.maximumResultItemsPerRow = this.categoryWidth / 18;
    }

    private int offsetLine(int origin) {
        return origin + 2 + this.lineHeight;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, RunewordRecipe recipe) {
        List<ItemStack> inputs = recipe.toMaterialsStackForJei();
        List<List<ItemStack>> resultItem = recipe.toResultSlotsForJei();
        this.createAndSetInput(builder, inputs, this.categoryWidth);
        this.createAndSetOutputs(builder, resultItem, this.categoryWidth);
    }

    private void createAndSetOutputs(IRecipeLayoutBuilder builder, List<List<ItemStack>> outputs, int categoryWidth) {
        int row = 0;
        int column = 0;
        int center = categoryWidth / 2;
        int offset = this.calculateCenteringOffset(outputs.size());
        for (List<ItemStack> output : outputs) {
            int x = center + offset;
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, x, this.slotsY + row * 18);
            slot.addItemStacks(output);
            offset += 18;
            if (++column < this.maximumResultItemsPerRow) continue;
            column = 0;
            offset = this.calculateCenteringOffset(outputs.size() - ++row * this.maximumResultItemsPerRow);
        }
    }

    private int calculateCenteringOffset(int size) {
        size = Math.min(size, this.maximumResultItemsPerRow);
        int offset = -(size / 2) * 18;
        if (size % 2 != 0) {
            offset = -((size + 1) / 2) * 18 + 9;
        }
        return offset;
    }

    private void createAndSetInput(IRecipeLayoutBuilder builder, List<ItemStack> inputs, int categoryWidth) {
        int center = categoryWidth / 2;
        int offset = this.calculateCenteringOffset(inputs.size());
        for (ItemStack input : inputs) {
            int x = center + offset;
            IRecipeSlotBuilder slot = builder.addSlot(RecipeIngredientRole.INPUT, x, this.inputY);
            slot.addItemStack(input);
            offset += 18;
        }
    }

    public void drawRunewordInfo(RunewordRecipe recipe, int recipeWidth, int recipeHeight, GuiGraphics guiGraphics) {
        Font font = Minecraft.m_91087_().f_91062_;
        MutableComponent nameText = recipe.locName().m_130944_(new ChatFormatting[]{ChatFormatting.YELLOW, ChatFormatting.BOLD});
        RunewordExtension.drawCenteredText(recipeWidth, guiGraphics, font, (Component)nameText, this.nameY);
        MutableComponent runewordText = Words.Runeword.locName().m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.BOLD});
        RunewordExtension.drawCenteredText(recipeWidth, guiGraphics, font, (Component)runewordText, this.runewordsTextY);
        MutableComponent slotsText = Words.ON_SLOTS.locName().m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.BOLD});
        RunewordExtension.drawCenteredText(recipeWidth, guiGraphics, font, (Component)slotsText, this.slotsTextY);
        int statY = this.statsY + this.slotsLines(recipe.slots.size());
        MutableComponent statsHeader = Words.Stats.locName().m_130946_(":");
        RunewordExtension.drawCenteredText(recipeWidth, guiGraphics, font, (Component)statsHeader, statY);
        statY = this.offsetLine(statY);
        for (StatMod stat : recipe.stats) {
            List<Component> statTooltips = stat.getEstimationTooltip(1);
            for (Component statLine : statTooltips) {
                RunewordExtension.drawCenteredText(recipeWidth, guiGraphics, font, statLine, statY);
                statY = this.offsetLine(statY);
            }
        }
    }

    private static void drawCenteredText(int recipeWidth, GuiGraphics guiGraphics, Font font, Component nameText, int y) {
        int x = recipeWidth / 2 - font.m_92852_((FormattedText)nameText) / 2;
        guiGraphics.m_280430_(font, nameText, x, y, 0xFFFFFF);
    }

    private int slotsLines(int totalItems) {
        return (int)(Math.ceil((float)totalItems / (float)this.maximumResultItemsPerRow) * 18.0);
    }

    public int calculateMaxHeight(int maxLines) {
        return this.offsetLines(this.slotsTextY + this.slotsLines(this.maximumResultItemsPerRow * 2) + 8, maxLines + 2);
    }

    private int offsetLines(int nameY, int amount) {
        for (int i = 0; i < amount; ++i) {
            nameY = this.offsetLine(nameY);
        }
        return nameY;
    }
}

