/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.a_libraries.dmg_number_particle.particle;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.robertx22.mine_and_slash.a_libraries.dmg_number_particle.particle.impl.DamageNullifiedParticle;
import com.robertx22.mine_and_slash.a_libraries.dmg_number_particle.particle.impl.ElementDamageParticle;
import com.robertx22.mine_and_slash.a_libraries.dmg_number_particle.particle.impl.HealParticle;
import com.robertx22.mine_and_slash.a_libraries.dmg_number_particle.particle.style.Default;
import com.robertx22.mine_and_slash.a_libraries.dmg_number_particle.particle.style.IParticleRenderMaterial;
import com.robertx22.mine_and_slash.a_libraries.dmg_number_particle.particle.style.Row;
import com.robertx22.mine_and_slash.uncommon.enumclasses.Elements;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.ClientOnly;
import com.robertx22.mine_and_slash.uncommon.utilityclasses.NumberUtils;
import com.robertx22.mine_and_slash.vanilla_mc.packets.interaction.IParticleSpawnMaterial;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.tuple.Pair;

public class InteractionResultHandler {

    public static enum ClientSpawnStrategy {
        DEFAULT((info, entity) -> {
            IParticleSpawnMaterial.DamageInformation mat = (IParticleSpawnMaterial.DamageInformation)info;
            ImmutableMap<Elements, Float> dmgMap = mat.getDmgMap();
            boolean crit = mat.isCrit();
            for (Map.Entry entry : dmgMap.entrySet()) {
                Float damage = (Float)entry.getValue();
                if (damage.intValue() <= 0) continue;
                double x = entity.m_20208_(0.5);
                double y = entity.m_20188_();
                double z = entity.m_20262_(0.5);
                String damageString = NumberUtils.format(damage.floatValue());
                Minecraft.m_91087_().f_91061_.m_107344_((Particle)new ElementDamageParticle(Minecraft.m_91087_().f_91073_, x, y, z, new Default(), new IParticleRenderMaterial.singleElement((Pair<Elements, String>)Pair.of((Object)((Object)((Elements)((Object)((Object)entry.getKey())))), (Object)damageString), crit)));
            }
        }, (type, entity) -> {
            IParticleSpawnMaterial.Type mat = (IParticleSpawnMaterial.Type)type;
            double x = entity.m_20208_(0.5);
            double y = entity.m_20188_();
            double z = entity.m_20262_(0.5);
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)new DamageNullifiedParticle(Minecraft.m_91087_().f_91073_, x, y, z, new Default(), mat));
            ClientOnly.getPlayer().m_9236_().m_245747_(entity.m_20183_(), mat.sound, SoundSource.PLAYERS, 1.0f, 1.5f, true);
        }, (type, entity) -> {
            IParticleSpawnMaterial.HealNumber mat = (IParticleSpawnMaterial.HealNumber)type;
            double x = entity.m_20208_(0.5);
            double y = entity.m_20188_();
            double z = entity.m_20262_(0.5);
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)new HealParticle(Minecraft.m_91087_().f_91073_, x, y, z, new Default(), mat.number()));
        }),
        IN_A_ROW((info, entity) -> {
            IParticleSpawnMaterial.DamageInformation mat = (IParticleSpawnMaterial.DamageInformation)info;
            ImmutableMap<Elements, Float> dmgMap = mat.getDmgMap();
            boolean crit = mat.isCrit();
            ImmutableList.Builder builder = ImmutableList.builder();
            dmgMap.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((Elements)((Object)((Object)((Object)entry.getKey())))).ordinal())).forEachOrdered(x -> {
                Elements key = (Elements)((Object)((Object)((Object)x.getKey())));
                String value = NumberUtils.format(((Float)x.getValue()).floatValue());
                builder.add((Object)Pair.of((Object)((Object)key), (Object)value));
            });
            Random random = new Random();
            double x2 = entity.m_20185_() + random.nextDouble(-1.0, 1.0);
            double y = entity.m_20188_() + random.nextDouble(-0.5, 0.8);
            double z = entity.m_20189_();
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)new ElementDamageParticle(Minecraft.m_91087_().f_91073_, x2, y, z, new Row(), new IParticleRenderMaterial.multipleElements((List<Pair<Elements, String>>)builder.build(), crit)));
        }, (type, entity) -> {
            IParticleSpawnMaterial.Type mat = (IParticleSpawnMaterial.Type)type;
            double x = entity.m_20185_();
            double y = entity.m_20188_();
            double z = entity.m_20189_();
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)new DamageNullifiedParticle(Minecraft.m_91087_().f_91073_, x, y, z, new Row(), mat));
        }, (type, entity) -> {
            IParticleSpawnMaterial.HealNumber mat = (IParticleSpawnMaterial.HealNumber)type;
            double x = entity.m_20185_();
            double y = entity.m_20188_();
            double z = entity.m_20189_();
            Minecraft.m_91087_().f_91061_.m_107344_((Particle)new HealParticle(Minecraft.m_91087_().f_91073_, x, y, z, new Row(), mat.number()));
        });

        public final BiConsumer<IParticleSpawnMaterial, Entity> damageStrategy;
        public final BiConsumer<IParticleSpawnMaterial, Entity> nullifiedDamageStrategy;
        public final BiConsumer<IParticleSpawnMaterial, Entity> healStrategy;

        private ClientSpawnStrategy(BiConsumer<IParticleSpawnMaterial, Entity> damageStrategy, BiConsumer<IParticleSpawnMaterial, Entity> nullifiedDamageStrategy, BiConsumer<IParticleSpawnMaterial, Entity> healStrategy) {
            this.damageStrategy = damageStrategy;
            this.nullifiedDamageStrategy = nullifiedDamageStrategy;
            this.healStrategy = healStrategy;
        }
    }

    public static enum ExileParticleType {
        DAMAGE(new IParticleSpawnMaterial.DamageInformation(null, null, false)),
        NULLIFIED_DAMAGE(IParticleSpawnMaterial.Type.DODGE),
        HEAL(new IParticleSpawnMaterial.HealNumber(0.0f));

        public final IParticleSpawnMaterial target;

        private ExileParticleType(IParticleSpawnMaterial target) {
            this.target = target;
        }
    }
}

