/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.mine_and_slash.a_libraries.curios;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICuriosItemHandler;
import top.theillusivec4.curios.api.type.inventory.ICurioStacksHandler;

public class MyCurioUtils {
    public static List<String> SLOTS = Arrays.asList("ring", "necklace", "omen", "backpack");

    public static List<ICurioStacksHandler> getHandlers(Player player) {
        return MyCurioUtils.getHandlers(SLOTS, player);
    }

    public static List<ICurioStacksHandler> getHandlers(List<String> slots, Player player) {
        ArrayList<ICurioStacksHandler> list = new ArrayList<ICurioStacksHandler>();
        ICuriosItemHandler handler = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).orElse(null);
        if (handler != null) {
            for (String slot : slots) {
                Optional sh = handler.getStacksHandler(slot);
                if (!sh.isPresent()) continue;
                list.add((ICurioStacksHandler)sh.get());
            }
        }
        return list;
    }

    public static List<ItemStack> getAllSlots(Player player) {
        ICuriosItemHandler handler = (ICuriosItemHandler)CuriosApi.getCuriosHelper().getCuriosHandler((LivingEntity)player).orElse(null);
        if (handler != null) {
            List<String> slots = handler.getCurios().entrySet().stream().map(x -> (String)x.getKey()).collect(Collectors.toList());
            return MyCurioUtils.getAllSlots(slots, player);
        }
        return Arrays.asList(new ItemStack[0]);
    }

    public static ItemStack get(String slot, Player player, int num) {
        List<ItemStack> list = MyCurioUtils.getAllSlots(Arrays.asList(slot), player);
        if (num + 1 > list.size()) {
            return ItemStack.f_41583_;
        }
        return list.get(num);
    }

    public static List<ItemStack> getAllSlots(List<String> slots, Player player) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        MyCurioUtils.getHandlers(slots, player).forEach(x -> {
            for (int i = 0; i < x.getSlots(); ++i) {
                ItemStack stack = x.getStacks().getStackInSlot(i);
                list.add(stack);
            }
        });
        return list;
    }
}

