/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.gear;

import com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.GearModification;
import com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.ItemModificationSers;
import com.robertx22.library_of_exile.localization.ExileTranslation;
import com.robertx22.library_of_exile.localization.TranslationBuilder;
import com.robertx22.library_of_exile.localization.TranslationType;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.mine_and_slash.database.data.rarities.GearRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.AffixData;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModification;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModificationResult;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.MutableComponent;

public class UpgradeAffixItemMod
extends GearModification {
    public AffixFinderData data;

    public UpgradeAffixItemMod(String id, AffixFinderData data) {
        super(ItemModificationSers.UPGRADE_AFFIX_RARITY, id);
        this.data = data;
    }

    @Override
    public void modifyGear(ExileStack stack, ItemModificationResult r) {
        stack.get(StackKeys.GEAR).edit(gear -> this.data.finder.getAffix(gear.affixes.getPrefixesAndSuffixes(), this.data).ifPresent(affix -> affix.upgradeRarity()));
    }

    public ItemModification.OutcomeType getOutcomeType() {
        return ItemModification.OutcomeType.GOOD;
    }

    public Class<?> getClassForSerialization() {
        return UpgradeAffixItemMod.class;
    }

    public MutableComponent getDescWithParams() {
        return this.getTranslation(TranslationType.DESCRIPTION).getTranslatedName(new Object[]{this.data.finder.getTooltip(this.data)});
    }

    public TranslationBuilder createTranslationBuilder() {
        return TranslationBuilder.of((String)"mmorpg").desc(ExileTranslation.registry((ExileRegistry)this, (String)"Upgrades Rarity and re-rolls Numbers of %1$s"));
    }

    public record AffixFinderData(AffixFinder finder, String target_rar) {
        GearRarity getTargetRarity() {
            return (GearRarity)ExileDB.GearRarities().get(this.target_rar);
        }
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum AffixFinder {
        SPECIFIC_RARITY(Words.SPECIFIC_RARITY_AFFIX){

            @Override
            public Optional<AffixData> getAffix(List<AffixData> affixes, AffixFinderData data) {
                return affixes.stream().filter(x -> x.rar.equals(data.target_rar)).findAny();
            }

            @Override
            public MutableComponent getTooltip(AffixFinderData data) {
                return this.getWordINTERNAL().locName(data.getTargetRarity().coloredName());
            }
        }
        ,
        RANDOM_AFFIX(Words.RANDOM_AFFIX){

            @Override
            public Optional<AffixData> getAffix(List<AffixData> affixes, AffixFinderData data) {
                return Optional.of((AffixData)RandomUtils.randomFromList(affixes));
            }
        }
        ,
        LOWEST_RARITY_AFFIX(Words.LOWEST_RARITY_AFFIX){

            @Override
            public Optional<AffixData> getAffix(List<AffixData> affixes, AffixFinderData data) {
                return affixes.stream().min(Comparator.comparingInt(x -> x.getRarity().item_tier));
            }
        };

        private Words word;

        public AffixFinderData get() {
            return new AffixFinderData(this, "");
        }

        public AffixFinderData ofSpecificRarity(String rar) {
            return new AffixFinderData(this, rar);
        }

        private AffixFinder(Words word) {
            this.word = word;
        }

        protected Words getWordINTERNAL() {
            return this.word;
        }

        public MutableComponent getTooltip(AffixFinderData data) {
            return this.word.locName();
        }

        public abstract Optional<AffixData> getAffix(List<AffixData> var1, AffixFinderData var2);
    }
}

