/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.gear;

import com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.GearModification;
import com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.ItemModificationSers;
import com.robertx22.library_of_exile.localization.ExileTranslation;
import com.robertx22.library_of_exile.localization.TranslationBuilder;
import com.robertx22.library_of_exile.localization.TranslationType;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModification;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModificationResult;
import net.minecraft.network.chat.MutableComponent;

public class ModifyUniqueStatsItemMod
extends GearModification {
    public Data data;

    public ModifyUniqueStatsItemMod(String id, Data data) {
        super(ItemModificationSers.MODIFY_UNIQUE_STATS, id);
        this.data = data;
    }

    @Override
    public void modifyGear(ExileStack stack, ItemModificationResult r) {
        stack.get(StackKeys.GEAR).edit(gear -> gear.uniqueStats.increaseAllBy((GearItemData)gear, this.data.num));
    }

    public Class<?> getClassForSerialization() {
        return ModifyUniqueStatsItemMod.class;
    }

    public ItemModification.OutcomeType getOutcomeType() {
        return this.data.num > 0 ? ItemModification.OutcomeType.GOOD : ItemModification.OutcomeType.BAD;
    }

    public MutableComponent getDescWithParams() {
        return this.getTranslation(TranslationType.DESCRIPTION).getTranslatedName(new Object[]{this.data.num});
    }

    public TranslationBuilder createTranslationBuilder() {
        Object term = "Adds";
        if (this.data.num < 0) {
            term = "Reduces";
        }
        term = (String)term + " %1$s Percent to Unique Stats";
        return TranslationBuilder.of((String)"mmorpg").desc(ExileTranslation.registry((ExileRegistry)this, (String)term));
    }

    public record Data(int num) {
    }
}

