/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.gear;

import com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.GearModification;
import com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.ItemModificationSers;
import com.robertx22.library_of_exile.localization.ExileTranslation;
import com.robertx22.library_of_exile.localization.TranslationBuilder;
import com.robertx22.library_of_exile.localization.TranslationType;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.mine_and_slash.database.data.runewords.RuneWord;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.saveclasses.gearitem.gear_parts.SocketData;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModification;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModificationResult;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;

public class ExtractSocketItemMod
extends GearModification {
    public SocketedType type;

    public ExtractSocketItemMod(String id, SocketedType data) {
        super(ItemModificationSers.EXTRACT_SOCKET, id);
        this.type = data;
    }

    @Override
    public void modifyGear(ExileStack stack, ItemModificationResult r) {
        stack.get(StackKeys.GEAR).edit(gear -> {
            SocketData socket;
            int index = gear.sockets.lastFilledSocketGemIndex(this.type);
            if (index > -1 && (socket = gear.sockets.getSocketed().get(index)).is(this.type)) {
                RuneWord runeword = null;
                if (gear.sockets.hasRuneWord()) {
                    runeword = gear.sockets.getRuneWord();
                }
                gear.sockets.getSocketed().remove(index);
                ItemStack extractedSocketItem = socket.getOriginalItemStack();
                r.extraItemsCreated.add(extractedSocketItem);
                if (gear.sockets.hasRuneWord() && !runeword.hasMatchingRunesToCreate((GearItemData)gear)) {
                    gear.sockets.removeRuneword();
                }
            }
        });
    }

    public ItemModification.OutcomeType getOutcomeType() {
        return ItemModification.OutcomeType.GOOD;
    }

    public MutableComponent getDescWithParams() {
        return this.getTranslation(TranslationType.DESCRIPTION).getTranslatedName(new Object[]{this.type.word.locName().m_130940_(ChatFormatting.YELLOW)});
    }

    public TranslationBuilder createTranslationBuilder() {
        return TranslationBuilder.of((String)"mmorpg").desc(ExileTranslation.registry((ExileRegistry)this, (String)"Extracts %1$s from a Socket"));
    }

    public Class<?> getClassForSerialization() {
        return ExtractSocketItemMod.class;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum SocketedType {
        GEM(Words.Gem){

            @Override
            public boolean is(SocketData data) {
                return data.getGem() != null;
            }
        }
        ,
        RUNE(Words.Rune){

            @Override
            public boolean is(SocketData data) {
                return data.getRune() != null;
            }
        };

        public Words word;

        private SocketedType(Words word) {
            this.word = word;
        }

        public abstract boolean is(SocketData var1);
    }
}

