/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.gear;

import com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.GearModification;
import com.robertx22.addons.orbs_of_crafting.currency.reworked.item_mod.ItemModificationSers;
import com.robertx22.library_of_exile.localization.ExileTranslation;
import com.robertx22.library_of_exile.localization.TranslationBuilder;
import com.robertx22.library_of_exile.localization.TranslationType;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.mine_and_slash.database.data.chaos_stats.ChaosStat;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.itemstack.CustomItemData;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModification;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModificationResult;
import net.minecraft.network.chat.MutableComponent;

public class CorruptGearItemMod
extends GearModification {
    public Data data;

    public CorruptGearItemMod(String id, Data data) {
        super(ItemModificationSers.CORRUPT_GEAR, id);
        this.data = data;
    }

    @Override
    public void modifyGear(ExileStack stack, ItemModificationResult r) {
        stack.get(StackKeys.GEAR).edit(gear -> {
            if (this.data.adds_affixes) {
                ChaosStat chaos = (ChaosStat)ExileDB.ChaosStats().getFilterWrapped(x -> x.for_item_rarities.contains(gear.rar)).random();
                chaos.applyToGear(stack);
            } else {
                stack.get(StackKeys.CUSTOM).edit(x -> x.data.set(CustomItemData.KEYS.CORRUPT, true));
                stack.get(StackKeys.POTENTIAL).edit(e -> {
                    e.potential = 0;
                });
            }
        });
    }

    public Class<?> getClassForSerialization() {
        return CorruptGearItemMod.class;
    }

    public ItemModification.OutcomeType getOutcomeType() {
        return this.data.adds_affixes ? ItemModification.OutcomeType.GOOD : ItemModification.OutcomeType.BAD;
    }

    public MutableComponent getDescWithParams() {
        return this.getTranslation(TranslationType.DESCRIPTION).getTranslatedName(new Object[0]);
    }

    public TranslationBuilder createTranslationBuilder() {
        Object t = "Corrupts the Item, making it unmodifiable";
        if (this.data.adds_affixes) {
            t = (String)t + " and adds a Random amount of Corruption Affixes";
        }
        return TranslationBuilder.of((String)"mmorpg").desc(ExileTranslation.registry((ExileRegistry)this, (String)t));
    }

    public record Data(boolean adds_affixes) {
    }
}

