/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.addons.orbs_of_crafting.currency.base;

import com.robertx22.addons.orbs_of_crafting.currency.base.CodeCurrency;
import com.robertx22.addons.orbs_of_crafting.currency.base.GearOutcome;
import com.robertx22.addons.orbs_of_crafting.currency.base.OutcomeType;
import com.robertx22.library_of_exile.util.ExplainedResult;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.mine_and_slash.gui.texts.textblocks.WorksOnBlock;
import com.robertx22.mine_and_slash.itemstack.ExileStack;
import com.robertx22.mine_and_slash.itemstack.StackKeys;
import com.robertx22.mine_and_slash.saveclasses.item_classes.GearItemData;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.orbs_of_crafting.misc.LocReqContext;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class GearCurrency
extends CodeCurrency {
    @Override
    public WorksOnBlock.ItemType usedOn() {
        return WorksOnBlock.ItemType.GEAR;
    }

    public abstract List<GearOutcome> getOutcomes();

    public abstract int getPotentialLoss();

    public boolean spendsGearPotential() {
        return this.getPotentialLoss() > 0;
    }

    @Override
    public void internalModifyMethod(LocReqContext ctx) {
        GearOutcome outcome = this.getOutcome();
        ExileStack ex = ExileStack.of(ctx.stack);
        StackKeys.POTENTIAL.get(ex).edit(x -> x.spend(this.getPotentialLoss()));
        ctx.stack = ex.getStack();
        Player player = ctx.player;
        if (outcome.getOutcomeType() == OutcomeType.GOOD) {
            SoundUtils.ding((Level)player.m_9236_(), (BlockPos)player.m_20183_());
            SoundUtils.playSound((Level)player.m_9236_(), (BlockPos)player.m_20183_(), (SoundEvent)SoundEvents.f_11671_, (float)1.0f, (float)1.0f);
        } else {
            SoundUtils.playSound((Level)player.m_9236_(), (BlockPos)player.m_20183_(), (SoundEvent)SoundEvents.f_11983_, (float)1.0f, (float)1.0f);
            SoundUtils.playSound((Level)player.m_9236_(), (BlockPos)player.m_20183_(), (SoundEvent)SoundEvents.f_12507_, (float)1.0f, (float)1.0f);
        }
        outcome.modify(ctx);
    }

    private GearOutcome getOutcome() {
        return (GearOutcome)RandomUtils.weightedRandom(this.getOutcomes());
    }

    @Override
    public ExplainedResult canItemBeModified(LocReqContext context) {
        ExileStack ex = ExileStack.of(context.stack);
        GearItemData data = ex.get(StackKeys.GEAR).get();
        if (data == null) {
            return ExplainedResult.failure((Component)Chats.NOT_GEAR.locName());
        }
        if (ex.isCorrupted() && this.spendsGearPotential()) {
            return ExplainedResult.failure((Component)Chats.CORRUPT_CANT_BE_MODIFIED.locName());
        }
        if ((!ex.get(StackKeys.POTENTIAL).has() || ex.get(StackKeys.POTENTIAL).get().potential < 1) && this.spendsGearPotential()) {
            return ExplainedResult.failure((Component)Chats.GEAR_NO_POTENTIAL.locName());
        }
        ExplainedResult can = this.canBeModified(context);
        if (!can.can) {
            return can;
        }
        return super.canItemBeModified(context);
    }

    public abstract ExplainedResult canBeModified(LocReqContext var1);
}

