/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.addons.dungeon_realm;

import com.robertx22.addons.dungeon_realm.DungeonAddonUtil;
import com.robertx22.dungeon_realm.api.CanEnterMapEvent;
import com.robertx22.dungeon_realm.api.CanStartMapEvent;
import com.robertx22.dungeon_realm.api.DungeonExileEvents;
import com.robertx22.dungeon_realm.api.OnGenerateNewMapItemEvent;
import com.robertx22.dungeon_realm.api.OnStartMapEvent;
import com.robertx22.dungeon_realm.api.PrepareDungeonMobEditsEvent;
import com.robertx22.dungeon_realm.api.SpawnUberEvent;
import com.robertx22.dungeon_realm.database.holders.DungeonMapBlocks;
import com.robertx22.dungeon_realm.main.DungeonMain;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.mine_and_slash.capability.entity.CooldownsData;
import com.robertx22.mine_and_slash.capability.world.WorldData;
import com.robertx22.mine_and_slash.config.forge.ServerContainer;
import com.robertx22.mine_and_slash.database.data.rarities.MobRarity;
import com.robertx22.mine_and_slash.database.registry.ExileDB;
import com.robertx22.mine_and_slash.loot.LootInfo;
import com.robertx22.mine_and_slash.loot.blueprints.MapBlueprint;
import com.robertx22.mine_and_slash.maps.MapData;
import com.robertx22.mine_and_slash.maps.MapItemData;
import com.robertx22.mine_and_slash.uncommon.ExplainedResultUtil;
import com.robertx22.mine_and_slash.uncommon.datasaving.Load;
import com.robertx22.mine_and_slash.uncommon.datasaving.StackSaving;
import com.robertx22.mine_and_slash.uncommon.localization.Chats;
import com.robertx22.mine_and_slash.uncommon.localization.Words;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class DungeonAddonEvents {
    public static void init() {
        DungeonExileEvents.ON_GENERATE_NEW_MAP_ITEM.register((EventConsumer)new EventConsumer<OnGenerateNewMapItemEvent>(){

            public void accept(OnGenerateNewMapItemEvent event) {
                MapBlueprint b = new MapBlueprint(LootInfo.ofLevel(1));
                StackSaving.MAP.saveTo(event.mapStack, (Object)b.createData());
            }
        });
        DungeonExileEvents.ON_START_NEW_MAP.register((EventConsumer)new EventConsumer<OnStartMapEvent>(){

            public void accept(OnStartMapEvent event) {
                MapItemData map;
                if (event.mapInfo.dimensionId.equals((Object)DungeonMain.DIMENSION_KEY) && (map = (MapItemData)StackSaving.MAP.loadFrom(event.stack)) != null) {
                    map.lvl = Load.Unit((Entity)event.p).getLevel();
                    MapData mapdata = MapData.newMap(event.p, map);
                    WorldData.get((Level)event.p.m_9236_()).map.setData(event.p, mapdata, event.mapInfo.structure, event.startChunkPos.m_151394_(5));
                    Load.Unit((Entity)event.p).getCooldowns().setOnCooldown("start_map", (Integer)ServerContainer.get().MAP_START_COOLDOWN_SECONDS.get() * 20);
                }
            }
        });
        DungeonExileEvents.ON_SPAWN_UBER_BOSS.register((EventConsumer)new EventConsumer<SpawnUberEvent>(){

            public void accept(SpawnUberEvent event) {
                LivingEntity en = event.uberBoss;
                Load.Unit((Entity)en).setRarity("uber");
                Load.Unit((Entity)en).recalcStats_DONT_CALL();
            }
        });
        DungeonExileEvents.PREPARE_DUNGEON_MOB_SPAWN.register((EventConsumer)new EventConsumer<PrepareDungeonMobEditsEvent>(){

            public void accept(PrepareDungeonMobEditsEvent event) {
                event.dataBlock.ifPresent(x -> {
                    MobRarity rar;
                    if (DungeonMapBlocks.INSTANCE.ELITE_MOB.GUID().equals(x.GUID()) || DungeonMapBlocks.INSTANCE.ELITE_MOB_HORDE.GUID().equals(x.GUID())) {
                        rar = (MobRarity)ExileDB.MobRarities().getFilterWrapped(e -> e.is_elite).random();
                        event.edits.add(DungeonAddonUtil.createMobRarityEdit(rar));
                    }
                    if (DungeonMapBlocks.INSTANCE.MAP_BOSS.GUID().equals(x.GUID())) {
                        rar = (MobRarity)ExileDB.MobRarities().get("boss");
                        event.edits.add(DungeonAddonUtil.createMobRarityEdit(rar));
                    }
                    if (DungeonMapBlocks.INSTANCE.BOSS.GUID().equals(x.GUID())) {
                        rar = (MobRarity)ExileDB.MobRarities().get("mythic");
                        event.edits.add(DungeonAddonUtil.createMobRarityEdit(rar));
                    }
                });
            }
        });
        DungeonExileEvents.CAN_START_MAP.register((EventConsumer)new EventConsumer<CanStartMapEvent>(){

            public void accept(CanStartMapEvent event) {
                Player p = event.p;
                if (Load.Unit((Entity)p).getLevel() < (Integer)ServerContainer.get().MIN_LEVEL_MAP_DROPS.get()) {
                    p.m_213846_((Component)ExplainedResultUtil.createErrorAndReason(Chats.MAP_DEVICE_USE_ERROR.locName(), Chats.TOO_LOW_LEVEL.locName(ServerContainer.get().MIN_LEVEL_MAP_DROPS.get())));
                    event.canEnter = false;
                    return;
                }
                MapItemData data = (MapItemData)StackSaving.MAP.loadFrom(event.stack);
                if (data == null) {
                    p.m_213846_((Component)ExplainedResultUtil.createErrorAndReason(Chats.MAP_DEVICE_USE_ERROR, Chats.INVALID_MAP_ITEM));
                    event.canEnter = false;
                    return;
                }
                if (!DungeonAddonEvents.checkCooldown(p)) {
                    event.canEnter = false;
                    return;
                }
                if (!DungeonAddonEvents.meetsResists(p, data)) {
                    event.canEnter = false;
                    return;
                }
            }
        });
        DungeonExileEvents.CAN_ENTER_MAP.register((EventConsumer)new EventConsumer<CanEnterMapEvent>(){

            public void accept(CanEnterMapEvent event) {
                try {
                    MapData map = (MapData)WorldData.get((Level)event.p.m_9236_()).map.getData((MapStructure)DungeonMain.MAIN_DUNGEON_STRUCTURE, event.mapDevice.pos);
                    if (map == null) {
                        event.canEnter = false;
                        return;
                    }
                    if (!DungeonAddonEvents.canJoinMap(event.p, map)) {
                        event.canEnter = false;
                        return;
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    static boolean checkCooldown(Player p) {
        CooldownsData cds = Load.Unit((Entity)p).getCooldowns();
        if (!p.m_7500_() && cds.isOnCooldown("start_map")) {
            int sec = cds.getCooldownTicks("start_map") / 20;
            p.m_213846_((Component)ExplainedResultUtil.createErrorAndReason(Chats.MAP_DEVICE_USE_ERROR.locName(), Words.MAP_START_COOLDOWN.locName(sec)));
            return false;
        }
        return true;
    }

    static boolean meetsResists(Player p, MapItemData data) {
        if (!data.getStatReq().meetsReq(Load.Unit((Entity)p).getLevel(), Load.Unit((Entity)p))) {
            ExplainedResultUtil.sendErrorMessage(p, Chats.MAP_DEVICE_USE_ERROR, Chats.RESISTS_TOO_LOW_FOR_MAP);
            List<Component> reqDifference = data.getStatReq().getReqDifference(data.lvl, Load.Unit((Entity)p));
            if (!reqDifference.isEmpty()) {
                ExplainedResultUtil.sendErrorMessage(p, Chats.MAP_DEVICE_USE_ERROR, Chats.NOT_MEET_MAP_REQ_FIRST_LINE);
                reqDifference.forEach(arg_0 -> ((Player)p).m_213846_(arg_0));
            }
            return false;
        }
        return true;
    }

    static boolean canJoinMap(Player p, MapData mapData) {
        if (!DungeonAddonEvents.meetsResists(p, mapData.map)) {
            return false;
        }
        MapItemData map1 = mapData.map;
        if (Load.Unit((Entity)p).getLevel() < map1.lvl - 5) {
            p.m_213846_((Component)ExplainedResultUtil.createErrorAndReason(Chats.MAP_DEVICE_USE_ERROR, Chats.TOO_LOW_LEVEL));
            return false;
        }
        return true;
    }
}

