/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.orbs_of_crafting.register;

import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.localization.ExileTranslation;
import com.robertx22.library_of_exile.localization.ITranslated;
import com.robertx22.library_of_exile.localization.TranslationBuilder;
import com.robertx22.library_of_exile.localization.TranslationType;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.IWeighted;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.registry.helpers.ExileCached;
import com.robertx22.library_of_exile.registry.helpers.ExileKey;
import com.robertx22.library_of_exile.registry.helpers.ExileKeyHolder;
import com.robertx22.library_of_exile.registry.helpers.IdKey;
import com.robertx22.library_of_exile.tooltip.ExileTooltipUtils;
import com.robertx22.library_of_exile.tooltip.TooltipBuilder;
import com.robertx22.library_of_exile.tooltip.order.ExileTooltipPart;
import com.robertx22.library_of_exile.tooltip.order.TooltipOrder;
import com.robertx22.library_of_exile.util.ExplainedResult;
import com.robertx22.library_of_exile.util.UNICODE;
import com.robertx22.library_of_exile.utils.RandomUtils;
import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import com.robertx22.orbs_of_crafting.api.CurrencyTooltip;
import com.robertx22.orbs_of_crafting.api.OrbEvents;
import com.robertx22.orbs_of_crafting.lang.OrbWords;
import com.robertx22.orbs_of_crafting.misc.LocReqContext;
import com.robertx22.orbs_of_crafting.misc.ModifyResult;
import com.robertx22.orbs_of_crafting.misc.ResultItem;
import com.robertx22.orbs_of_crafting.misc.StackHolder;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModification;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModificationResult;
import com.robertx22.orbs_of_crafting.register.orb_edit.OrbEdit;
import com.robertx22.orbs_of_crafting.register.reqs.base.ItemRequirement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class ExileCurrency
implements ITranslated,
IAutoGson<ExileCurrency>,
JsonExileRegistry<ExileCurrency> {
    public static ExileCurrency SERIALIZER = new ExileCurrency();
    String id;
    public int weight = 1000;
    public transient String locname = "";
    public transient String modid = "";
    List<ItemModData> pick_one_item_mod = new ArrayList<ItemModData>();
    List<ItemModData> always_do_item_mods = new ArrayList<ItemModData>();
    List<String> req = new ArrayList<String>();
    public String rar = "rare";
    public List<String> item_type_requirement = new ArrayList<String>();
    public PotentialData potential = new PotentialData(true, 1);
    public String item_id = "";
    public transient List<String> editsApplied = new ArrayList<String>();
    public static ExileCached<HashMap<Item, ExileCurrency>> CACHED_MAP = new ExileCached<HashMap>(() -> {
        HashMap<Item, ExileCurrency> map = new HashMap<Item, ExileCurrency>();
        for (ExileCurrency cur : LibDatabase.Currency().getList()) {
            Item i = cur.getItem();
            if (i == Items.f_41852_) continue;
            map.put(i, cur);
        }
        return map;
    }).clearOnDatabaseChange();

    public void applyEdits(OrbEdit edit) {
        if (this.editsApplied.contains(edit.GUID())) {
            return;
        }
        this.editsApplied.add(edit.GUID());
        for (ItemModData mod : edit.always_do_item_mods) {
            this.always_do_item_mods.add(mod);
        }
        for (ItemModData mod : edit.pick_one_item_mod) {
            this.pick_one_item_mod.add(mod);
        }
        for (String r : edit.req) {
            this.req.add(r);
        }
    }

    @Override
    public TranslationBuilder createTranslationBuilder() {
        return new TranslationBuilder(this.modid).name(ExileTranslation.item(this.getItem(), this.locname));
    }

    public List<ItemRequirement> getItemTypeRequirement() {
        return this.item_type_requirement.stream().map(x -> LibDatabase.ItemReq().get((String)x)).collect(Collectors.toList());
    }

    public Item getItem() {
        return VanillaUTIL.REGISTRY.items().get(new ResourceLocation(this.item_id));
    }

    public static Optional<ExileCurrency> get(ItemStack stack) {
        ExileCurrency res = CACHED_MAP.get().get(stack.m_41720_());
        return Optional.ofNullable(res);
    }

    public ResultItem modifyItem(LocReqContext ctx) {
        Object res;
        OrbEvents.Modify event = new OrbEvents.Modify(this, ctx);
        OrbEvents.MODIFY.callEvents(event);
        StackHolder holder = new StackHolder(ctx.stack);
        boolean bad = false;
        try {
            res = new ItemModificationResult();
            for (ItemModData mod : this.always_do_item_mods) {
                mod.get().applyMod(ctx.player, holder, (ItemModificationResult)res);
            }
            if (!this.pick_one_item_mod.isEmpty()) {
                ItemModData picked = RandomUtils.weightedRandom(this.pick_one_item_mod);
                picked.get().applyMod(ctx.player, holder, (ItemModificationResult)res);
                if (picked.get().getOutcomeType() == ItemModification.OutcomeType.BAD) {
                    bad = true;
                }
            }
            ((ItemModificationResult)res).onFinish(ctx.player);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ResultItem(holder.stack, ModifyResult.ERROR, ExplainedResult.failure((Component)Component.m_237113_((String)"Code error caused the action to fail.")));
        }
        res = new ResultItem(holder.stack, ModifyResult.SUCCESS, ExplainedResult.success());
        if (bad) {
            ((ResultItem)res).outcome = ItemModification.OutcomeType.BAD;
        }
        return res;
    }

    public List<Component> getTooltip() {
        TooltipBuilder<CurrencyTooltip> b = new TooltipBuilder<CurrencyTooltip>(new CurrencyTooltip(ItemStack.f_41583_, this));
        b.add(x -> new ExileTooltipPart(TooltipOrder.FIRST, (Component[])new MutableComponent[]{this.getTranslation(TranslationType.NAME).getTranslatedName(new Object[0]).m_130940_(ChatFormatting.BOLD)}));
        b.add(x -> {
            ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
            for (ItemRequirement req : this.getItemTypeRequirement()) {
                list.add(req.getDescWithParams().m_130940_(ChatFormatting.YELLOW));
            }
            return new ExileTooltipPart(TooltipOrder.EARLY, (List<? extends Component>)list);
        });
        b.add(x -> {
            ChatFormatting color;
            ArrayList<MutableComponent> all = new ArrayList<MutableComponent>();
            int totalWeight = this.pick_one_item_mod.stream().mapToInt(IWeighted::Weight).sum();
            if (!this.pick_one_item_mod.isEmpty()) {
                all.add(Component.m_237119_());
                all.add(OrbWords.RANDOM_OUTCOME.get(new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.GREEN, ChatFormatting.BOLD}));
                for (ItemModData data : this.pick_one_item_mod) {
                    color = data.get().getOutcomeType().color;
                    all.add(this.getChanceTooltip(data, totalWeight, true).m_130940_(color));
                }
            }
            if (!this.always_do_item_mods.isEmpty()) {
                all.add(Component.m_237119_());
                all.add(OrbWords.ALWAYS_DOES.get(new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.RED, ChatFormatting.BOLD}));
                for (ItemModData data : this.always_do_item_mods) {
                    color = data.get().getOutcomeType().color;
                    all.add(this.getChanceTooltip(data, data.weight, false).m_130940_(color));
                }
            }
            all.add(Component.m_237119_());
            all.add(OrbWords.Requirements.get(new Object[0]).m_130944_(new ChatFormatting[]{ChatFormatting.DARK_PURPLE, ChatFormatting.BOLD}));
            for (String s : this.req) {
                ItemRequirement req = LibDatabase.ItemReq().get(s);
                all.add(Component.m_237113_((String)(UNICODE.ROTATED_CUBE + " ")).m_7220_((Component)req.getDescWithParams()).m_130940_(ChatFormatting.LIGHT_PURPLE));
            }
            return new ExileTooltipPart(TooltipOrder.EARLY, (List<? extends Component>)all);
        });
        if (this.potential.potential_cost > 0) {
            b.add(x -> {
                ArrayList<MutableComponent> list = new ArrayList<MutableComponent>();
                if (this.potential.potential_cost > 0) {
                    list.add(OrbWords.POTENTIAL_COST.get(Component.m_237113_((String)("" + this.potential.potential_cost)).m_130940_(ChatFormatting.GOLD)).m_130940_(ChatFormatting.GOLD));
                } else {
                    list.add(OrbWords.NOT_A_POTENTIAL_CONSUMER.get(new Object[0]).m_130940_(ChatFormatting.GOLD));
                }
                return new ExileTooltipPart(TooltipOrder.MIDDLE, (List<? extends Component>)list);
            });
        }
        b.add(x -> new ExileTooltipPart(TooltipOrder.LATE, (Component[])new MutableComponent[]{OrbWords.Currency.get(new Object[0]).m_130940_(ChatFormatting.GOLD)}));
        return b.build();
    }

    private MutableComponent getChanceTooltip(ItemModData mod, int totalweight, boolean addchance) {
        if (!addchance) {
            return Component.m_237113_((String)(UNICODE.STAR + " ")).m_7220_((Component)mod.get().getDescWithParams()).m_130940_(ChatFormatting.YELLOW);
        }
        int chance = (int)((float)mod.weight / (float)totalweight * 100.0f);
        return Component.m_237113_((String)(UNICODE.STAR + " ")).m_7220_((Component)OrbWords.OUTCOME_TIP.get(mod.get().getDescWithParams(), Component.m_237113_((String)(chance + "%")).m_130940_(ChatFormatting.YELLOW)));
    }

    public ExplainedResult canItemBeModified(LocReqContext context) {
        List<ItemRequirement> type = this.getItemTypeRequirement();
        if (!type.isEmpty() && type.stream().noneMatch(x -> x.isValid(context.player, new StackHolder(context.stack)))) {
            if (type.size() == 1) {
                return ExplainedResult.failure((Component)type.get(0).getDescWithParams());
            }
            ArrayList<MutableComponent> all = new ArrayList<MutableComponent>();
            for (ItemRequirement req : type) {
                all.add(req.getDescWithParams());
            }
            return ExplainedResult.failure((Component)ExileTooltipUtils.joinMutableComps(all.iterator(), Component.m_237113_((String)" or ")));
        }
        OrbEvents.CanBeModified event = new OrbEvents.CanBeModified(this, context);
        OrbEvents.CAN_BE_MODIFIED.callEvents(event);
        if (event.result != null) {
            return event.result;
        }
        for (String s : this.req) {
            ItemRequirement r = LibDatabase.ItemReq().get(s);
            if (r.isValid(context.player, new StackHolder(context.stack))) continue;
            return ExplainedResult.failure((Component)r.getDescWithParams());
        }
        return ExplainedResult.success();
    }

    @Override
    public void onLoadedFromJson() {
        CACHED_MAP.clear();
    }

    @Override
    public ExileRegistryType getExileRegistryType() {
        return LibDatabase.CURRENCY;
    }

    @Override
    public Class<ExileCurrency> getClassForSerialization() {
        return ExileCurrency.class;
    }

    @Override
    public String GUID() {
        return this.id;
    }

    @Override
    public int Weight() {
        return this.weight;
    }

    public static class PotentialData {
        public boolean needs_potential = true;
        public int potential_cost = 0;

        public PotentialData(int potential_cost) {
            this.potential_cost = potential_cost;
        }

        public PotentialData(boolean needs_potential, int potential_cost) {
            this.needs_potential = needs_potential;
            this.potential_cost = potential_cost;
        }
    }

    public static class ItemModData
    implements IWeighted {
        public String id = "";
        public int weight = 1000;

        public ItemModData(String id, int weight) {
            this.id = id;
            this.weight = weight;
        }

        public ItemModification get() {
            return LibDatabase.ItemMods().get(this.id);
        }

        @Override
        public int Weight() {
            return this.weight;
        }
    }

    public static class Builder {
        public List<ItemModData> pickOneMods = new ArrayList<ItemModData>();
        public List<ItemModData> useAllMods = new ArrayList<ItemModData>();
        public List<String> req = new ArrayList<String>();
        public String id;
        public PotentialData pot = new PotentialData(1);
        public int weight = 1000;
        public String name;
        public List<String> type = new ArrayList<String>();
        public String rar = "rare";

        public static Builder of(String id, String name, ExileKey<ItemRequirement, ?> ... type) {
            return new Builder(id, name, type);
        }

        public Builder(String id, String name, ExileKey<ItemRequirement, ?> ... type) {
            this.id = id;
            this.name = name;
            for (ExileKey<ItemRequirement, ?> t : type) {
                this.type.add(t.GUID());
            }
        }

        public Builder addModification(ExileKey<ItemModification, ?> modification, int weight) {
            this.pickOneMods.add(new ItemModData(modification.GUID(), weight));
            return this;
        }

        public Builder addAlwaysUseModification(ExileKey<ItemModification, ?> modification) {
            this.useAllMods.add(new ItemModData(modification.GUID(), 1));
            return this;
        }

        public Builder addRequirement(ExileKey<ItemRequirement, ?> requirement) {
            this.req.add(requirement.GUID());
            return this;
        }

        public Builder rarity(String rar) {
            this.rar = rar;
            return this;
        }

        public Builder edit(Consumer<Builder> c) {
            c.accept(this);
            return this;
        }

        public Builder weight(int w) {
            this.weight = w;
            return this;
        }

        public Builder potentialCost(int cost) {
            this.pot.potential_cost = cost;
            return this;
        }

        public ExileKey<ExileCurrency, IdKey> build(ExileKeyHolder<ExileCurrency> holder) {
            return new ExileKey<ExileCurrency, IdKey>(holder, new IdKey(this.id), (x, y) -> this.buildCurrency(holder), this.id);
        }

        public ExileCurrency buildCurrency(ExileKeyHolder<ExileCurrency> holder) {
            ExileCurrency currency = new ExileCurrency();
            currency.modid = holder.modRegisterInfo.modid;
            currency.id = this.id;
            currency.pick_one_item_mod = this.pickOneMods;
            currency.req = this.req;
            currency.always_do_item_mods = this.useAllMods;
            currency.item_type_requirement = this.type;
            currency.rar = this.rar;
            currency.locname = this.name;
            currency.weight = this.weight;
            currency.potential = this.pot;
            currency.item_id = holder.getItemId(currency.id).toString();
            return currency;
        }
    }
}

