/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.orbs_of_crafting.misc;

import com.robertx22.library_of_exile.main.ApiForgeEvents;
import com.robertx22.library_of_exile.util.ExplainedResult;
import com.robertx22.library_of_exile.utils.SoundUtils;
import com.robertx22.orbs_of_crafting.misc.LocReqContext;
import com.robertx22.orbs_of_crafting.misc.ModifyResult;
import com.robertx22.orbs_of_crafting.misc.ResultItem;
import com.robertx22.orbs_of_crafting.register.ExileCurrency;
import com.robertx22.orbs_of_crafting.register.mods.base.ItemModification;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.ItemStackedOnOtherEvent;

public class OnClick {
    static List<ClickFeature> CLICKS = new ArrayList<ClickFeature>();

    public static void register() {
        CLICKS.add(new ClickFeature(){

            @Override
            public Result tryApply(Player player, ItemStack craftedStack, ItemStack currency, Slot slot) {
                Optional<ExileCurrency> opt = ExileCurrency.get(currency);
                Optional<ExileCurrency> opt2 = ExileCurrency.get(craftedStack);
                if (opt2.isPresent()) {
                    return new Result(false);
                }
                if (opt.isPresent()) {
                    LocReqContext ctx = new LocReqContext(player, craftedStack.m_41777_(), currency);
                    ExileCurrency cur = opt.get();
                    if (!craftedStack.m_41619_()) {
                        ExplainedResult can = cur.canItemBeModified(ctx);
                        if (can.can) {
                            ResultItem result = cur.modifyItem(ctx);
                            if (result.resultEnum != ModifyResult.SUCCESS) {
                                player.m_213846_(result.result.answer);
                                return new Result(false);
                            }
                            craftedStack.m_41774_(1);
                            currency.m_41774_(1);
                            slot.m_5852_(result.stack.m_41777_());
                            if (result.outcome == ItemModification.OutcomeType.BAD) {
                                SoundUtils.playSound(player.m_9236_(), player.m_20183_(), SoundEvents.f_11983_, 1.0f, 1.0f);
                                return new Result(true);
                            }
                            if (result.outcome == ItemModification.OutcomeType.NEUTRAL) {
                                SoundUtils.playSound(player.m_9236_(), player.m_20183_(), SoundEvents.f_12447_, 1.0f, 1.0f);
                                return new Result(true);
                            }
                            return new Result(true).ding();
                        }
                        SoundUtils.playSound(player.m_9236_(), player.m_20183_(), SoundEvents.f_12507_, 1.0f, 1.0f);
                        player.m_213846_(can.answer);
                    }
                }
                return new Result(false);
            }
        });
        ApiForgeEvents.registerForgeEvent(ItemStackedOnOtherEvent.class, x -> {
            Player player = x.getPlayer();
            if (player.m_9236_().f_46443_) {
                return;
            }
            if (x.getClickAction() != ClickAction.SECONDARY) {
                // empty if block
            }
            ItemStack currency = x.getStackedOnItem();
            ItemStack craftedStack = x.getCarriedItem();
            for (ClickFeature click : CLICKS) {
                Result result = click.tryApply(player, craftedStack, currency, x.getSlot());
                if (result.doDing) {
                    SoundUtils.ding(player.m_9236_(), player.m_20183_());
                    SoundUtils.playSound(player.m_9236_(), player.m_20183_(), SoundEvents.f_11671_, 1.0f, 1.0f);
                }
                if (!result.can) continue;
                x.setCanceled(true);
                break;
            }
        });
    }

    private static abstract class ClickFeature {
        private ClickFeature() {
        }

        public abstract Result tryApply(Player var1, ItemStack var2, ItemStack var3, Slot var4);
    }

    private static class Result {
        public boolean can;
        private boolean doDing = false;

        public Result(boolean can) {
            this.can = can;
        }

        public Result ding() {
            this.doDing = true;
            return this;
        }
    }
}

