/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.utils;

import com.robertx22.library_of_exile.components.DelayedTeleportData;
import com.robertx22.library_of_exile.components.PlayerDataCapability;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import com.robertx22.library_of_exile.dimension.structure.SimplePrebuiltMapData;
import com.robertx22.library_of_exile.dimension.structure.SimplePrebuiltMapStructure;
import com.robertx22.library_of_exile.dimension.teleport.SavedTeleportPos;
import com.robertx22.library_of_exile.vanilla_util.main.VanillaUTIL;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.dimension.DimensionType;
import org.jetbrains.annotations.NotNull;

public class TeleportUtils {
    public static void teleport(ServerPlayer player, BlockPos pos) {
        TeleportUtils.teleport(player, pos, player.m_9236_().m_6042_());
    }

    public static void teleport(ServerPlayer player, BlockPos pos, DimensionType dimension) {
        TeleportUtils.teleport(player, pos, VanillaUTIL.REGISTRY.dimensionTypes(player.m_9236_()).getKey(dimension));
    }

    public static void teleport(ServerPlayer player, BlockPos pos, ResourceLocation dimension) {
        try {
            String command = "/execute in " + dimension.toString() + " run tp " + player.m_20149_() + " " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_();
            PlayerDataCapability.get((Player)player).delayedTeleportData = new DelayedTeleportData(command, 2, SavedTeleportPos.from(dimension, pos));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static BlockPos getSpawnTeleportPos(MapStructure<?> structure, BlockPos startAt) {
        BlockPos p = TeleportUtils.getOriginalTeleportPos(structure, startAt);
        if (structure instanceof SimplePrebuiltMapStructure) {
            SimplePrebuiltMapStructure simplePrebuiltMapStructure = (SimplePrebuiltMapStructure)structure;
            SimplePrebuiltMapData map = (SimplePrebuiltMapData)simplePrebuiltMapStructure.getMap(structure.getStartChunkPos(startAt));
            p = p.m_7918_(map.teleport_offset_x, map.teleport_offset_y, map.teleport_offset_z);
        }
        return p;
    }

    @NotNull
    public static BlockPos getOriginalTeleportPos(MapStructure<?> structure, BlockPos pos) {
        BlockPos p = structure.getStartChunkPos(pos).m_151394_(structure.getSpawnHeight() + 5);
        p = new BlockPos(p.m_123341_(), structure.getSpawnHeight() + 5, p.m_123343_());
        return p;
    }
}

