/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.tags;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

public class ExileTagRequirementEntry {
    public TagRequirementCheck check = TagRequirementCheck.HAS_ALL;
    public List<String> tags = new ArrayList<String>();

    public ExileTagRequirementEntry(TagRequirementCheck check, List<String> tags) {
        this.check = check;
        this.tags = tags;
    }

    public ExileTagRequirementEntry(TagRequirementCheck check, String ... tags) {
        this.check = check;
        this.tags = Arrays.asList(tags);
    }

    public String toString() {
        return "ExileTagRequirementEntry{check=" + this.check + ", tags=" + this.tags + "}";
    }

    public boolean matches(List<String> objTags) {
        return this.check.matches(objTags, this.tags);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum TagRequirementCheck {
        HAS_ALL{

            @Override
            public boolean matches(List<String> objTags, List<String> tags) {
                return new HashSet<String>(objTags).containsAll(tags);
            }
        }
        ,
        HAS_ANY{

            @Override
            public boolean matches(List<String> objTags, List<String> tags) {
                return tags.stream().anyMatch(x -> objTags.contains(x));
            }
        }
        ,
        HAS_NONE{

            @Override
            public boolean matches(List<String> objTags, List<String> tags) {
                return tags.stream().anyMatch(x -> !objTags.contains(x));
            }
        };


        public abstract boolean matches(List<String> var1, List<String> var2);
    }
}

