/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry.helpers;

import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.helpers.ExileKey;
import com.robertx22.library_of_exile.registry.helpers.ExileKeyHolder;
import com.robertx22.library_of_exile.registry.helpers.KeyInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ExileKeyMap<T extends ExileRegistry<T>, Info extends KeyInfo> {
    String id_prefix;
    public Function<Info, String> idMaker = x -> this.id_prefix + "_" + x.GUID();
    public List<Info> all = new ArrayList<Info>();
    public HashMap<Info, ExileKey<T, Info>> map = new HashMap();
    ExileKeyHolder holder;

    public String getId(Info info) {
        return this.idMaker.apply(info);
    }

    public ExileKey<T, Info> get(Info info) {
        return this.map.get(info);
    }

    public ExileKeyMap(ExileKeyHolder<T> holder, String id_prefix) {
        this.id_prefix = id_prefix;
        this.holder = holder;
    }

    public ExileKeyMap<T, Info> ofList(List<Info> all) {
        this.all = all;
        return this;
    }

    public <R> ExileKeyMap<T, Info> ofList(List<R> all, Function<R, Info> f) {
        this.all = all.stream().map(f).collect(Collectors.toList());
        return this;
    }

    private void b(BiFunction<String, Info, T> classMaker) {
        for (KeyInfo info : this.all) {
            ExileKey<T, KeyInfo> key = new ExileKey<T, KeyInfo>(this.holder, info, classMaker, this.idMaker.apply(info));
            this.map.put(info, key);
        }
    }

    public ExileKeyMap<T, Info> build(BiFunction<String, Info, T> classMaker) {
        this.b(classMaker);
        return this;
    }
}

