/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.registry.helpers;

import com.google.common.base.Preconditions;
import com.robertx22.library_of_exile.deferred.RegObj;
import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.recipe.ConditionalRecipeData;
import com.robertx22.library_of_exile.recipe.RecipeGenerator;
import com.robertx22.library_of_exile.registry.ExileRegistry;
import com.robertx22.library_of_exile.registry.ExileRegistryEvent;
import com.robertx22.library_of_exile.registry.ExileRegistryType;
import com.robertx22.library_of_exile.registry.IGUID;
import com.robertx22.library_of_exile.registry.JsonExileRegistry;
import com.robertx22.library_of_exile.registry.helpers.ExileKeyHolder;
import com.robertx22.library_of_exile.registry.helpers.IdKey;
import com.robertx22.library_of_exile.registry.helpers.KeyInfo;
import com.robertx22.library_of_exile.registry.register_info.ModRequiredRegisterInfo;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public class ExileKey<T extends ExileRegistry<T>, Info extends KeyInfo>
implements IGUID {
    public Info info;
    private BiFunction<String, Info, T> sup;
    private T obj;
    ExileKeyHolder holder;
    String id;
    RegObj<Item> item = null;
    ModRequiredRegisterInfo modRegisterInfo;
    private boolean cancelItemCreation = false;

    public ExileKey(ExileKeyHolder holder, Info info, BiFunction<String, Info, T> sup, String id) {
        this.holder = holder;
        this.info = info;
        this.modRegisterInfo = holder.modRegisterInfo;
        this.sup = sup;
        this.id = id;
        holder.all.put(this.GUID(), this);
    }

    public T get() {
        Preconditions.checkNotNull(this.obj);
        return this.obj;
    }

    public Item getItem() {
        if (this.item == null) {
            throw new RuntimeException("No item for registry key: " + this.id);
        }
        return this.item.get();
    }

    public boolean hasItem() {
        return this.item != null;
    }

    public ExileKey<T, Info> addRecipe(ExileRegistryType type, Function<ExileKey<T, Info>, ShapedRecipeBuilder> b) {
        RecipeGenerator.addRecipe(this.modRegisterInfo.modid, () -> (RecipeBuilder)b.apply(this));
        return this;
    }

    public ExileKey<T, Info> addConditional(String requiredModid, Function<ExileKey<T, Info>, ShapedRecipeBuilder> b) {
        RecipeGenerator.addConditional(this.modRegisterInfo.modid, () -> ConditionalRecipeData.ofModLoaded(requiredModid, new ResourceLocation(this.modRegisterInfo.modid, this.GUID()), c -> ((ShapedRecipeBuilder)b.apply(this)).m_176498_(c)));
        return this;
    }

    public ExileKey<T, Info> doNotCreateItem() {
        this.cancelItemCreation = true;
        return this;
    }

    public boolean isCancelItemCreation() {
        return this.cancelItemCreation;
    }

    @Override
    public String GUID() {
        return this.id;
    }

    public static <T extends ExileRegistry<T>, Info extends KeyInfo> ExileKey<T, Info> ofId(ExileKeyHolder holder, String id, Function<Info, T> sup) {
        return new ExileKey<ExileRegistry, KeyInfo>(holder, new IdKey(id), (s, info) -> (ExileRegistry)sup.apply(info), id);
    }

    public void register() {
        this.obj = (ExileRegistry)this.sup.apply(this.id, this.info);
        ExileEvents.EXILE_REGISTRY_GATHER.register(new EventConsumer<ExileRegistryEvent>(){

            @Override
            public void accept(ExileRegistryEvent e) {
                if (e.type == ExileKey.this.obj.getExileRegistryType()) {
                    Object t = ExileKey.this.obj;
                    if (t instanceof JsonExileRegistry) {
                        JsonExileRegistry j = (JsonExileRegistry)t;
                        e.addSeriazable(j, ExileKey.this.modRegisterInfo.ser);
                    } else {
                        e.add((ExileRegistry<?>)ExileKey.this.obj, ExileKey.this.modRegisterInfo.hard);
                    }
                }
            }
        });
    }
}

