/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.dimension;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.robertx22.library_of_exile.dimension.MapChunkGenEvent;
import com.robertx22.library_of_exile.dimension.MapGenEvents;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.FixedBiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.flat.FlatLevelGeneratorSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class MapChunkGenerator
extends ChunkGenerator {
    public static final Codec<MapChunkGenerator> CODEC = RecordCodecBuilder.create(b -> {
        Products.P2 group = b.group((App)FlatLevelGeneratorSettings.f_70347_.fieldOf("settings").forGetter(x -> x.settings), (App)ExtraCodecs.f_263723_.fieldOf("map_id").forGetter(x -> x.mapId));
        return group.apply((Applicative)b, b.stable((x, y) -> new MapChunkGenerator((FlatLevelGeneratorSettings)x, (String)y)));
    });
    public final FlatLevelGeneratorSettings settings;
    public String mapId;

    public MapChunkGenerator(FlatLevelGeneratorSettings set, String mapid) {
        super((BiomeSource)new FixedBiomeSource(set.m_204921_()));
        this.settings = set;
        this.mapId = mapid;
    }

    protected Codec<? extends ChunkGenerator> m_6909_() {
        return CODEC;
    }

    public void m_213679_(WorldGenRegion pLevel, long pSeed, RandomState pRandom, BiomeManager pBiomeManager, StructureManager pStructureManager, ChunkAccess pChunk, GenerationStep.Carving pStep) {
    }

    public void m_214194_(WorldGenRegion pLevel, StructureManager pStructureManager, RandomState pRandom, ChunkAccess pChunk) {
        MapChunkGenEvent event = new MapChunkGenEvent(pRandom, pLevel.m_7654_().m_236738_(), pChunk, pLevel, this.mapId);
        MapGenEvents.MAP_CHUNK_GEN.callEvents(event);
    }

    public void m_6929_(WorldGenRegion pLevel) {
    }

    public CompletableFuture<ChunkAccess> m_213974_(Executor pExecutor, Blender pBlender, RandomState pRandom, StructureManager pStructureManager, ChunkAccess pChunk) {
        BlockState blockstate = Blocks.f_50752_.m_49966_();
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = pChunk.m_141937_(); i < pChunk.m_141928_(); ++i) {
            for (int k = 0; k < 16; ++k) {
                for (int l = 0; l < 16; ++l) {
                    pChunk.m_6978_((BlockPos)blockpos$mutableblockpos.m_122178_(k, i, l), blockstate, false);
                }
            }
        }
        return CompletableFuture.completedFuture(pChunk);
    }

    public int m_142062_() {
        return 0;
    }

    public int m_6331_() {
        return 384;
    }

    public int m_6337_() {
        return -63;
    }

    public int m_214096_(int pX, int pZ, Heightmap.Types pType, LevelHeightAccessor pLevel, RandomState pRandom) {
        List list = this.settings.m_161917_();
        for (int i = Math.min(list.size(), pLevel.m_151558_()) - 1; i >= 0; --i) {
            BlockState blockstate = (BlockState)list.get(i);
            if (blockstate == null || !pType.m_64299_().test(blockstate)) continue;
            return pLevel.m_141937_() + i + 1;
        }
        return pLevel.m_141937_();
    }

    public NoiseColumn m_214184_(int pX, int pZ, LevelHeightAccessor pHeight, RandomState pRandom) {
        return new NoiseColumn(pHeight.m_141937_(), (BlockState[])this.settings.m_161917_().stream().limit(pHeight.m_141928_()).map(p_204549_ -> p_204549_ == null ? Blocks.f_50016_.m_49966_() : p_204549_).toArray(BlockState[]::new));
    }

    public void m_213600_(List<String> pInfo, RandomState pRandom, BlockPos pPos) {
    }

    public void m_255037_(RegistryAccess pRegistryAccess, ChunkGeneratorStructureState pStructureState, StructureManager pStructureManager, ChunkAccess pChunk, StructureTemplateManager pStructureTemplateManager) {
    }
}

