/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.database.affix.types;

import com.robertx22.library_of_exile.database.affix.apply_strat.ApplyStrategy;
import com.robertx22.library_of_exile.database.affix.apply_strat.PotionApplyStrategy;
import com.robertx22.library_of_exile.database.affix.base.AffixTranslation;
import com.robertx22.library_of_exile.database.affix.types.AffixNumberRange;
import com.robertx22.library_of_exile.database.affix.types.ExileMobAffix;
import com.robertx22.library_of_exile.localization.ExileTranslation;
import com.robertx22.library_of_exile.localization.TranslationBuilder;
import com.robertx22.library_of_exile.localization.TranslationType;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.registries.ForgeRegistries;

public class PotionMobAffix
extends ExileMobAffix {
    public Data data;

    public PotionMobAffix(ExileMobAffix.Affects affects, String id, int weight, Data data, AffixTranslation t) {
        super("potion_mob_affix", affects, id, weight, t);
        this.data = data;
    }

    public void tryApply(int perc, LivingEntity en) {
        if (en.f_19797_ % (20 * this.data.apply_every_x_seconds) == 0) {
            MobEffectInstance instance = new MobEffectInstance(this.data.getEffect(), this.data.duration_ticks.getInt(perc), this.data.amplifer.getInt(perc));
            en.m_7292_(instance);
        }
    }

    @Override
    public Class<PotionMobAffix> getClassForSerialization() {
        return PotionMobAffix.class;
    }

    @Override
    public ApplyStrategy getApplyStrategy() {
        return PotionApplyStrategy.INSTANCE;
    }

    @Override
    public TranslationBuilder createTranslationBuilder() {
        return TranslationBuilder.of(this.modid).name(ExileTranslation.of(this.modid + ".potion_mob_affix", this.locName));
    }

    @Override
    public MutableComponent getParamName(int perc) {
        int sec = this.data.duration_ticks.getInt(perc) / 20;
        return this.getTranslation(TranslationType.NAME).getTranslatedName(this.data.getEffect().m_19482_(), this.data.amplifer.getInt(perc), sec, this.data.apply_every_x_seconds).m_130940_(ChatFormatting.GREEN);
    }

    public record Data(String status_effect_id, AffixNumberRange amplifer, AffixNumberRange duration_ticks, int apply_every_x_seconds) {
        public static Data of(MobEffect effect, AffixNumberRange amp, AffixNumberRange durationTicks, int apply_every_x_seconds) {
            return new Data(BuiltInRegistries.f_256974_.m_7981_((Object)effect).toString(), amp, durationTicks, apply_every_x_seconds);
        }

        public static Data of5sEvery10s(MobEffect effect, AffixNumberRange amp) {
            return new Data(BuiltInRegistries.f_256974_.m_7981_((Object)effect).toString(), amp, new AffixNumberRange(100.0f, 100.0f), 10);
        }

        public static Data of3sEvery10s(MobEffect effect, AffixNumberRange amp) {
            return new Data(BuiltInRegistries.f_256974_.m_7981_((Object)effect).toString(), amp, new AffixNumberRange(60.0f, 60.0f), 10);
        }

        public static Data of1sEvery10s(MobEffect effect, AffixNumberRange amp) {
            return new Data(BuiltInRegistries.f_256974_.m_7981_((Object)effect).toString(), amp, new AffixNumberRange(20.0f, 20.0f), 10);
        }

        public static Data ofPermanent(MobEffect effect, AffixNumberRange amp) {
            return new Data(BuiltInRegistries.f_256974_.m_7981_((Object)effect).toString(), amp, new AffixNumberRange(200.0f, 200.0f), 10);
        }

        public MobEffect getEffect() {
            return (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(new ResourceLocation(this.status_effect_id));
        }
    }
}

