/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.library_of_exile.custom_ser;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.robertx22.library_of_exile.custom_ser.ICustomSer;
import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.registry.IAutoGson;
import com.robertx22.library_of_exile.registry.serialization.ISerializable;

public interface GsonCustomSer<T>
extends ICustomSer<T>,
ISerializable<T> {
    public Class<?> getClassForSerialization();

    @Override
    default public T fromJson(JsonObject json) {
        String serid = json.get("serializer").getAsString();
        GsonCustomSer ser = (GsonCustomSer)this.getSerMap().map.get(serid);
        if (ser == null) {
            ExileLog.get().warn(serid + " is not an existing serializer", new Object[0]);
        }
        T t = ser.fromJsonNormal(json, ser.getClassForSerialization());
        return t;
    }

    default public T fromJsonNormal(JsonObject json, Class<?> c) {
        Object t = IAutoGson.GSON.fromJson((JsonElement)json, c);
        return (T)t;
    }

    @Override
    default public JsonObject toJson() {
        return IAutoGson.PARSER.parse(IAutoGson.GSON.toJson((Object)this)).getAsJsonObject();
    }
}

