/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.utils;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.function.Supplier;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import pro.gravit.utils.enfs.dir.FileEntry;
import pro.gravit.utils.helper.SecurityHelper;

public class RuntimeCryptedFile
extends FileEntry {
    private final Supplier<InputStream> inputStream;
    private final String alg;
    private final SecretKeySpec sKeySpec;
    private final IvParameterSpec iKeySpec;

    public RuntimeCryptedFile(Supplier<InputStream> inputStream, byte[] key) {
        this.inputStream = inputStream;
        this.alg = "AES/CBC/PKCS5Padding";
        try {
            byte[] compat = SecurityHelper.getAESKey((byte[])key);
            this.sKeySpec = new SecretKeySpec(compat, "AES");
            this.iKeySpec = new IvParameterSpec("8u3d90ikr7o67lsq".getBytes());
        }
        catch (Exception e) {
            throw new SecurityException(e);
        }
    }

    public InputStream getInputStream() throws IOException {
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(this.alg);
            cipher.init(2, (Key)this.sKeySpec, this.iKeySpec);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e) {
            throw new IOException(e);
        }
        return new BufferedInputStream(new CipherInputStream(this.inputStream.get(), cipher));
    }

    public long getContentLength() {
        return Long.MAX_VALUE;
    }
}

