/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.service;

import java.nio.file.Path;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.runtime.client.DirBridge;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;

public class JavaService {
    private static final Pattern JAVA_VERSION_PATTERN = Pattern.compile("Java (?<version>.+) b(?<build>.+) (?<os>.+) (?<arch>.+) javafx (?<javafx>.+)");
    public volatile List<JavaHelper.JavaVersion> javaVersions;
    private final JavaFXApplication application;

    public JavaService(JavaFXApplication application) {
        this.application = application;
        this.update();
    }

    public void update() {
        LinkedList<JavaHelper.JavaVersion> versions = new LinkedList<JavaHelper.JavaVersion>();
        if (this.application.guiModuleConfig.javaList != null) {
            for (Map.Entry<String, String> entry : this.application.guiModuleConfig.javaList.entrySet()) {
                String javaDir = entry.getKey();
                String javaVersionString = entry.getValue();
                Matcher matcher = JAVA_VERSION_PATTERN.matcher(javaVersionString);
                if (matcher.matches()) {
                    String os = matcher.group("os");
                    int version = Integer.parseInt(matcher.group("version"));
                    int build = Integer.parseInt(matcher.group("build"));
                    JVMHelper.ARCH arch = JVMHelper.ARCH.valueOf((String)matcher.group("arch"));
                    boolean javafx = Boolean.parseBoolean(matcher.group("javafx"));
                    if (!this.isArchAvailable(arch) || !JVMHelper.OS_TYPE.name.equals(os)) continue;
                    Path javaDirectory = DirBridge.dirUpdates.resolve(javaDir);
                    LogHelper.debug((String)"In-Launcher Java Version found: Java %d b%d %s javafx %s", (Object[])new Object[]{version, build, arch.name, Boolean.toString(javafx)});
                    JavaHelper.JavaVersion javaVersion = new JavaHelper.JavaVersion(javaDirectory, version, build, arch, javafx);
                    versions.add(javaVersion);
                    continue;
                }
                LogHelper.warning((String)"Java Version: %s does not match", (Object[])new Object[]{javaVersionString});
            }
        }
        if (!this.application.guiModuleConfig.forceDownloadJava || versions.isEmpty()) {
            versions.addAll(JavaHelper.findJava());
        }
        this.javaVersions = Collections.unmodifiableList(versions);
    }

    public boolean isArchAvailable(JVMHelper.ARCH arch) {
        if (JVMHelper.ARCH_TYPE == arch) {
            return true;
        }
        if (arch == JVMHelper.ARCH.X86_64 && JVMHelper.OS_TYPE == JVMHelper.OS.MUSTDIE && (JVMHelper.ARCH_TYPE == JVMHelper.ARCH.X86 && !JVMHelper.isJVMMatchesSystemArch() || JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM64)) {
            return true;
        }
        return arch == JVMHelper.ARCH.X86_64 && JVMHelper.OS_TYPE == JVMHelper.OS.MACOSX && JVMHelper.ARCH_TYPE == JVMHelper.ARCH.ARM64;
    }

    public boolean isIncompatibleJava(JavaHelper.JavaVersion version, ClientProfile profile) {
        return version.version > profile.getMaxJavaVersion() || version.version < profile.getMinJavaVersion();
    }

    public boolean contains(Path dir) {
        for (JavaHelper.JavaVersion version : this.javaVersions) {
            if (!version.jvmDir.toAbsolutePath().equals(dir.toAbsolutePath())) continue;
            return true;
        }
        return false;
    }

    public JavaHelper.JavaVersion getRecommendJavaVersion(ClientProfile profile) {
        int min = profile.getMinJavaVersion();
        int max = profile.getMaxJavaVersion();
        int recommend = profile.getRecommendJavaVersion();
        JavaHelper.JavaVersion result = null;
        for (JavaHelper.JavaVersion version : this.javaVersions) {
            if (version.version < min || version.version > max || this.isIncompatibleJava(version, profile)) continue;
            if (result == null) {
                result = version;
                continue;
            }
            if (result.version != recommend && version.version == recommend) {
                result = version;
                continue;
            }
            if (result.version == recommend != (version.version == recommend)) continue;
            if (result.version < version.version) {
                result = version;
                continue;
            }
            if (result.arch == JVMHelper.ARCH.X86 && version.arch == JVMHelper.ARCH.X86_64 || result.arch == JVMHelper.ARCH.X86_64 && version.arch == JVMHelper.ARCH.ARM64) {
                result = version;
            }
            if (result.version != version.version || result.build >= version.build) continue;
            result = version;
        }
        return result;
    }
}

