/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.update;

import java.nio.file.Path;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBase;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextArea;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.base.profiles.optional.OptionalView;
import pro.gravit.launcher.core.hasher.FileNameMatcher;
import pro.gravit.launcher.core.hasher.HashedDir;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.scenes.update.VisualDownloader;
import pro.gravit.utils.helper.LogHelper;

public class UpdateScene
extends AbstractScene {
    private ProgressBar progressBar;
    private Label speed;
    private Label volume;
    private TextArea logOutput;
    private Button cancel;
    private Label speedtext;
    private Label speederr;
    private Pane speedon;
    private VisualDownloader downloader;
    private volatile DownloadStatus downloadStatus = DownloadStatus.COMPLETE;

    public UpdateScene(JavaFXApplication application) {
        super("scenes/update/update.fxml", application);
    }

    @Override
    protected void doInit() {
        this.progressBar = (ProgressBar)LookupHelper.lookup((Node)this.layout, "#progress");
        this.speed = (Label)LookupHelper.lookup((Node)this.layout, "#speed");
        this.speederr = (Label)LookupHelper.lookup((Node)this.layout, "#speedErr");
        this.speedon = (Pane)LookupHelper.lookup((Node)this.layout, "#speedOn");
        this.speedtext = (Label)LookupHelper.lookup((Node)this.layout, "#speed-text");
        this.cancel = (Button)LookupHelper.lookup((Node)this.layout, "#cancel");
        this.volume = (Label)LookupHelper.lookup((Node)this.layout, "#volume");
        this.logOutput = (TextArea)LookupHelper.lookup((Node)this.layout, "#outputUpdate");
        this.downloader = new VisualDownloader(this.application, this.progressBar, this.speed, this.volume, this::errorHandle, log -> this.contextHelper.runInFxThread(() -> this.addLog((String)log)), this::onUpdateStatus);
        ((ButtonBase)LookupHelper.lookup((Node)this.layout, "#cancel")).setOnAction(e -> {
            if (this.downloadStatus == DownloadStatus.DOWNLOAD && this.downloader.isDownload()) {
                this.downloader.cancel();
            } else if (this.downloadStatus == DownloadStatus.ERROR || this.downloadStatus == DownloadStatus.COMPLETE) {
                try {
                    this.switchToBackScene();
                }
                catch (Exception exception) {
                    this.errorHandle(exception);
                }
            }
        });
    }

    private void onUpdateStatus(DownloadStatus newStatus) {
        this.downloadStatus = newStatus;
        LogHelper.debug((String)"Update download status: %s", (Object[])new Object[]{newStatus.toString()});
    }

    public void sendUpdateAssetRequest(String dirName, Path dir, FileNameMatcher matcher, boolean digest, String assetIndex, boolean test, Consumer<HashedDir> onSuccess) {
        this.downloader.sendUpdateAssetRequest(dirName, dir, matcher, digest, assetIndex, test, onSuccess);
    }

    public void sendUpdateRequest(String dirName, Path dir, FileNameMatcher matcher, boolean digest, OptionalView view, boolean optionalsEnabled, boolean test, Consumer<HashedDir> onSuccess) {
        this.downloader.sendUpdateRequest(dirName, dir, matcher, digest, view, optionalsEnabled, test, onSuccess);
    }

    public void addLog(String string) {
        LogHelper.dev((String)"Update event %s", (Object[])new Object[]{string});
        this.logOutput.appendText(string.concat("\n"));
    }

    @Override
    public void reset() {
        this.progressBar.progressProperty().setValue((Number)0);
        this.logOutput.setText("");
        this.volume.setText("");
        this.speed.setText("0");
        this.progressBar.getStyleClass().removeAll((Object[])new String[]{"progress"});
        this.speederr.setVisible(false);
        this.speedon.setVisible(true);
    }

    @Override
    public void errorHandle(Throwable e) {
        if (e instanceof CompletionException) {
            e = e.getCause();
        }
        this.addLog("Exception %s: %s".formatted(e.getClass(), e.getMessage() == null ? "" : e.getMessage()));
        this.progressBar.getStyleClass().add((Object)"progressError");
        this.speederr.setVisible(true);
        this.speedon.setVisible(false);
        LogHelper.error((Throwable)e);
    }

    @Override
    public boolean isDisableReturnBack() {
        return true;
    }

    @Override
    public String getName() {
        return "update";
    }

    public static enum DownloadStatus {
        ERROR,
        HASHING,
        REQUEST,
        DOWNLOAD,
        COMPLETE,
        DELETE;

    }
}

