/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.settings.components;

import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.Pane;
import javafx.stage.PopupWindow;
import javafx.util.Callback;
import javafx.util.StringConverter;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.gui.config.RuntimeSettings;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.service.JavaService;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.LogHelper;

public class JavaSelectorComponent {
    private final ComboBox<JavaHelper.JavaVersion> comboBox;
    private final RuntimeSettings.ProfileSettingsView profileSettings;
    private final ClientProfile profile;
    private final JavaService javaService;

    public JavaSelectorComponent(JavaService javaService, Pane layout, RuntimeSettings.ProfileSettingsView profileSettings, ClientProfile profile) {
        this.comboBox = (ComboBox)LookupHelper.lookup((Node)layout, "#javaCombo");
        this.profile = profile;
        this.comboBox.getItems().clear();
        this.profileSettings = profileSettings;
        this.javaService = javaService;
        this.comboBox.setConverter((StringConverter)new JavaVersionConverter(profile));
        this.comboBox.setCellFactory((Callback)new JavaVersionCellFactory((StringConverter<JavaHelper.JavaVersion>)this.comboBox.getConverter()));
        this.reset();
    }

    public void reset() {
        JavaHelper.JavaVersion recommend;
        boolean reset = true;
        for (JavaHelper.JavaVersion version : this.javaService.javaVersions) {
            if (this.javaService.isIncompatibleJava(version, this.profile)) continue;
            this.comboBox.getItems().add((Object)version);
            if (this.profileSettings.javaPath == null || !this.profileSettings.javaPath.equals(version.jvmDir.toString())) continue;
            this.comboBox.setValue((Object)version);
            reset = false;
        }
        if (this.comboBox.getTooltip() != null) {
            this.comboBox.getTooltip().setText(this.profileSettings.javaPath);
        }
        if (reset && (recommend = this.javaService.getRecommendJavaVersion(this.profile)) != null) {
            LogHelper.warning((String)"Selected Java Version not found. Using %s", (Object[])new Object[]{recommend.jvmDir.toAbsolutePath().toString()});
            this.comboBox.getSelectionModel().select((Object)recommend);
            this.profileSettings.javaPath = recommend.jvmDir.toAbsolutePath().toString();
        }
        this.comboBox.setOnAction(e -> {
            JavaHelper.JavaVersion version = (JavaHelper.JavaVersion)this.comboBox.getValue();
            if (version == null) {
                return;
            }
            String path = version.jvmDir.toAbsolutePath().toString();
            if (this.comboBox.getTooltip() != null) {
                this.comboBox.getTooltip().setText(path);
            }
            LogHelper.info((String)"Select Java %s", (Object[])new Object[]{path});
            this.profileSettings.javaPath = path;
        });
    }

    public String getPath() {
        return ((JavaHelper.JavaVersion)this.comboBox.getValue()).jvmDir.toAbsolutePath().toString();
    }

    private static class JavaVersionConverter
    extends StringConverter<JavaHelper.JavaVersion> {
        private final ClientProfile profile;

        private JavaVersionConverter(ClientProfile profile) {
            this.profile = profile;
        }

        public String toString(JavaHelper.JavaVersion object) {
            if (object == null) {
                return "Unknown";
            }
            String postfix = "";
            if (object.version == this.profile.getRecommendJavaVersion()) {
                postfix = "[RECOMMENDED]";
            }
            return "Java %d b%d %s".formatted(object.version, object.build, postfix);
        }

        public JavaHelper.JavaVersion fromString(String string) {
            return null;
        }
    }

    private static class JavaVersionCellFactory
    implements Callback<ListView<JavaHelper.JavaVersion>, ListCell<JavaHelper.JavaVersion>> {
        private final StringConverter<JavaHelper.JavaVersion> converter;

        public JavaVersionCellFactory(StringConverter<JavaHelper.JavaVersion> converter) {
            this.converter = converter;
        }

        public ListCell<JavaHelper.JavaVersion> call(ListView<JavaHelper.JavaVersion> param) {
            return new JavaVersionListCell(this.converter);
        }
    }

    private static class JavaVersionListCell
    extends ListCell<JavaHelper.JavaVersion> {
        private final StringConverter<JavaHelper.JavaVersion> converter;

        public JavaVersionListCell(StringConverter<JavaHelper.JavaVersion> converter) {
            this.converter = converter;
        }

        protected void updateItem(JavaHelper.JavaVersion item, boolean empty) {
            super.updateItem((Object)item, empty);
            if (empty || item == null) {
                this.setText(null);
                this.setTooltip(null);
            } else {
                this.setText(this.converter.toString((Object)item));
                Tooltip tooltip = new Tooltip(item.jvmDir.toString());
                tooltip.setAnchorLocation(PopupWindow.AnchorLocation.WINDOW_BOTTOM_LEFT);
                this.setTooltip(tooltip);
            }
        }
    }
}

