/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.settings;

import java.text.MessageFormat;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Slider;
import javafx.util.StringConverter;
import oshi.SystemInfo;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.components.UserBlock;
import pro.gravit.launcher.gui.config.RuntimeSettings;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.scenes.interfaces.SceneSupportUserBlock;
import pro.gravit.launcher.gui.scenes.settings.BaseSettingsScene;
import pro.gravit.launcher.gui.scenes.settings.components.JavaSelectorComponent;
import pro.gravit.launcher.gui.utils.SystemMemory;
import pro.gravit.utils.helper.JVMHelper;

public class SettingsScene
extends BaseSettingsScene
implements SceneSupportUserBlock {
    private static final long MAX_JAVA_MEMORY_X64 = 32768L;
    private static final long MAX_JAVA_MEMORY_X32 = 1536L;
    private Label ramLabel;
    private Slider ramSlider;
    private RuntimeSettings.ProfileSettingsView profileSettings;
    private JavaSelectorComponent javaSelector;
    private UserBlock userBlock;

    public SettingsScene(JavaFXApplication application) {
        super("scenes/settings/settings.fxml", application);
    }

    @Override
    protected void doInit() {
        long maxSystemMemory;
        super.doInit();
        this.userBlock = new UserBlock(this.layout, new AbstractScene.SceneAccessor());
        this.ramSlider = (Slider)LookupHelper.lookup((Node)this.componentList, "#ramSlider");
        this.ramLabel = (Label)LookupHelper.lookup((Node)this.componentList, "#ramLabel");
        try {
            SystemInfo systemInfo = new SystemInfo();
            maxSystemMemory = systemInfo.getHardware().getMemory().getTotal() >> 20;
        }
        catch (Throwable ignored) {
            try {
                maxSystemMemory = SystemMemory.getPhysicalMemorySize() >> 20;
            }
            catch (Throwable ignored1) {
                maxSystemMemory = 2048L;
            }
        }
        this.ramSlider.setMax((double)Math.min(maxSystemMemory, this.getJavaMaxMemory()));
        this.ramSlider.setSnapToTicks(true);
        this.ramSlider.setShowTickMarks(true);
        this.ramSlider.setShowTickLabels(true);
        this.ramSlider.setMinorTickCount(1);
        this.ramSlider.setMajorTickUnit(1024.0);
        this.ramSlider.setBlockIncrement(1024.0);
        this.ramSlider.setLabelFormatter((StringConverter)new StringConverter<Double>(){

            public String toString(Double object) {
                return "%.0fG".formatted(object / 1024.0);
            }

            public Double fromString(String string) {
                return null;
            }
        });
        LookupHelper.lookupIfPossible((Node)this.layout, "#back").ifPresent(a -> a.setOnAction(e -> {
            try {
                this.profileSettings = null;
                this.switchToBackScene();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        this.reset();
    }

    private long getJavaMaxMemory() {
        if (this.application.javaService.isArchAvailable(JVMHelper.ARCH.X86_64) || this.application.javaService.isArchAvailable(JVMHelper.ARCH.ARM64)) {
            return 32768L;
        }
        return 1536L;
    }

    @Override
    public void reset() {
        super.reset();
        this.profileSettings = new RuntimeSettings.ProfileSettingsView(this.application.getProfileSettings());
        this.javaSelector = new JavaSelectorComponent(this.application.javaService, this.componentList, this.profileSettings, this.application.profilesService.getProfile());
        this.ramSlider.setValue((double)this.profileSettings.ram);
        this.ramSlider.valueProperty().addListener((observable, oldValue, newValue) -> {
            this.profileSettings.ram = newValue.intValue();
            this.updateRamLabel();
        });
        this.updateRamLabel();
        LookupHelper.lookupIfPossible((Node)this.layout, "#savepanel", "#save").ifPresent(saveButton -> saveButton.setOnAction(e -> {
            try {
                this.profileSettings.apply();
                ClientProfile profile = this.application.profilesService.getProfile();
                this.application.triggerManager.process(profile, this.application.profilesService.getOptionalView());
                this.switchToBackScene();
            }
            catch (Exception exception) {
                this.errorHandle(exception);
            }
        }));
        LookupHelper.lookupIfPossible((Node)this.layout, "#savepanel", "#clientSettings").ifPresent(settingsButton -> settingsButton.setOnAction(e -> this.reset()));
        this.add("Debug", this.application.runtimeSettings.globalSettings.debugAllClients || this.profileSettings.debug, value -> {
            this.profileSettings.debug = value;
        }, this.application.runtimeSettings.globalSettings.debugAllClients);
        this.add("AutoEnter", this.profileSettings.autoEnter, value -> {
            this.profileSettings.autoEnter = value;
        }, false);
        this.add("Fullscreen", this.profileSettings.fullScreen, value -> {
            this.profileSettings.fullScreen = value;
        }, false);
        if (JVMHelper.OS_TYPE == JVMHelper.OS.LINUX) {
            this.add("WaylandSupport", this.profileSettings.waylandSupport, value -> {
                this.profileSettings.waylandSupport = value;
            }, false);
        }
        if (this.application.authService.checkDebugPermission("skipupdate")) {
            this.add("DebugSkipUpdate", this.profileSettings.debugSkipUpdate, value -> {
                this.profileSettings.debugSkipUpdate = value;
            }, false);
        }
        if (this.application.authService.checkDebugPermission("skipfilemonitor")) {
            this.add("DebugSkipFileMonitor", this.profileSettings.debugSkipFileMonitor, value -> {
                this.profileSettings.debugSkipFileMonitor = value;
            }, false);
        }
        this.userBlock.reset();
    }

    @Override
    public UserBlock getUserBlock() {
        return this.userBlock;
    }

    @Override
    public String getName() {
        return "settings";
    }

    public void updateRamLabel() {
        this.ramLabel.setText(this.profileSettings.ram == 0 ? this.application.getTranslation("runtime.scenes.settings.ramAuto") : MessageFormat.format(this.application.getTranslation("runtime.scenes.settings.ram"), this.profileSettings.ram));
    }
}

