/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes.login;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Button;
import pro.gravit.launcher.gui.JavaFXApplication;

public class LoginAuthButtonComponent {
    private final JavaFXApplication application;
    private final Button button;
    private AuthButtonState state = AuthButtonState.UNACTIVE;
    private String originalText;

    public LoginAuthButtonComponent(Button authButton, JavaFXApplication application, EventHandler<ActionEvent> eventHandler) {
        this.application = application;
        this.button = authButton;
        this.button.setOnAction(eventHandler);
        this.originalText = this.button.getText();
    }

    public AuthButtonState getState() {
        return this.state;
    }

    public void setState(AuthButtonState state) {
        if (state == null) {
            throw new NullPointerException("State can't be null");
        }
        if (state == this.state) {
            return;
        }
        if (this.state != null) {
            this.button.getStyleClass().remove((Object)this.state.getStyleClass());
        }
        this.button.getStyleClass().add((Object)state.getStyleClass());
        if (state == AuthButtonState.ERROR) {
            this.button.setText("ERROR");
        } else if (this.state == AuthButtonState.ERROR) {
            this.button.setText(this.originalText);
        }
        this.state = state;
    }

    public String getText() {
        return this.button.getText();
    }

    public void setText(String text) {
        this.button.setText(text);
        this.originalText = text;
    }

    public static enum AuthButtonState {
        ACTIVE("activeButton"),
        UNACTIVE("unactiveButton"),
        ERROR("errorButton");

        private final String styleClass;

        public String getStyleClass() {
            return this.styleClass;
        }

        private AuthButtonState(String styleClass) {
            this.styleClass = styleClass;
        }
    }
}

