/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.scenes;

import java.util.function.Consumer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.layout.Pane;
import pro.gravit.launcher.base.Launcher;
import pro.gravit.launcher.base.LauncherConfig;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.WebSocketEvent;
import pro.gravit.launcher.base.request.auth.ExitRequest;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.helper.LookupHelper;
import pro.gravit.launcher.gui.impl.AbstractStage;
import pro.gravit.launcher.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.gui.impl.ContextHelper;
import pro.gravit.launcher.gui.overlays.AbstractOverlay;

public abstract class AbstractScene
extends AbstractVisualComponent {
    protected final LauncherConfig launcherConfig = Launcher.getConfig();
    protected Pane header;

    protected AbstractScene(String fxmlPath, JavaFXApplication application) {
        super(fxmlPath, application);
    }

    protected AbstractStage getCurrentStage() {
        return this.currentStage;
    }

    @Override
    public void init() throws Exception {
        this.layout = (Pane)this.getFxmlRoot();
        this.header = LookupHelper.lookupIfPossible((Node)this.layout, "#header").orElse(null);
        this.sceneBaseInit();
        super.init();
    }

    @Override
    protected abstract void doInit();

    @Override
    protected void doPostInit() {
    }

    protected void onShow() {
    }

    protected void onHide() {
    }

    public void showOverlay(AbstractOverlay overlay, EventHandler<ActionEvent> onFinished) throws Exception {
        overlay.show(this.currentStage, onFinished);
    }

    protected final <T extends WebSocketEvent> void processRequest(String message, Request<T> request, Consumer<T> onSuccess, EventHandler<ActionEvent> onError) {
        this.application.gui.processingOverlay.processRequest(this.currentStage, message, request, onSuccess, onError);
    }

    protected final <T extends WebSocketEvent> void processRequest(String message, Request<T> request, Consumer<T> onSuccess, Consumer<Throwable> onException, EventHandler<ActionEvent> onError) {
        this.application.gui.processingOverlay.processRequest(this.currentStage, message, request, onSuccess, onException, onError);
    }

    protected void sceneBaseInit() {
        this.initBasicControls((Parent)this.header);
        LookupHelper.lookupIfPossible((Node)this.layout, "#leftpanel").ifPresent(leftpanel -> LookupHelper.lookupIfPossible((Node)leftpanel, "#deauth").ifPresent(b -> b.setOnAction(e -> this.application.messageManager.showApplyDialog(this.application.getTranslation("runtime.scenes.settings.exitDialog.header"), this.application.getTranslation("runtime.scenes.settings.exitDialog.description"), this::userExit, () -> {}, true))));
    }

    protected void userExit() {
        this.processRequest(this.application.getTranslation("runtime.scenes.settings.exitDialog.processing"), (Request)new ExitRequest(), event -> ContextHelper.runInFxThreadStatic(() -> {
            this.application.gui.loginScene.clearPassword();
            this.application.gui.loginScene.reset();
            try {
                this.application.saveSettings();
                this.application.authService.exit();
                this.switchScene(this.application.gui.loginScene);
            }
            catch (Exception ex) {
                this.errorHandle(ex);
            }
        }), (EventHandler<ActionEvent>)((EventHandler)event -> {}));
    }

    protected void switchToBackScene() throws Exception {
        this.currentStage.back();
    }

    @Override
    public void disable() {
        this.currentStage.disable();
    }

    @Override
    public void enable() {
        this.currentStage.enable();
    }

    @Override
    public abstract void reset();

    protected void switchScene(AbstractScene scene) throws Exception {
        this.currentStage.setScene(scene, true);
        this.onHide();
        scene.onShow();
    }

    public Node getHeader() {
        return this.header;
    }

    public static void runLater(double delay, EventHandler<ActionEvent> callback) {
        AbstractScene.fade(null, delay, 0.0, 1.0, callback);
    }

    public class SceneAccessor {
        public void showOverlay(AbstractOverlay overlay, EventHandler<ActionEvent> onFinished) throws Exception {
            AbstractScene.this.showOverlay(overlay, onFinished);
        }

        public JavaFXApplication getApplication() {
            return AbstractScene.this.application;
        }

        public void errorHandle(Throwable e) {
            AbstractScene.this.errorHandle(e);
        }

        public void runInFxThread(ContextHelper.GuiExceptionRunnable runnable) {
            AbstractScene.this.contextHelper.runInFxThread(runnable);
        }

        public <T extends WebSocketEvent> void processRequest(String message, Request<T> request, Consumer<T> onSuccess, EventHandler<ActionEvent> onError) {
            AbstractScene.this.processRequest(message, request, onSuccess, onError);
        }

        public final <T extends WebSocketEvent> void processRequest(String message, Request<T> request, Consumer<T> onSuccess, Consumer<Throwable> onException, EventHandler<ActionEvent> onError) {
            AbstractScene.this.processRequest(message, request, onSuccess, onException, onError);
        }
    }
}

