/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.impl;

import java.util.UUID;
import javafx.application.Platform;
import pro.gravit.launcher.base.events.RequestEvent;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.events.request.ProfilesRequestEvent;
import pro.gravit.launcher.base.profiles.ClientProfile;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.WebSocketEvent;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.scenes.AbstractScene;
import pro.gravit.launcher.gui.scenes.login.AuthFlow;
import pro.gravit.launcher.gui.scenes.login.LoginScene;
import pro.gravit.launcher.gui.scenes.options.OptionsScene;
import pro.gravit.launcher.gui.scenes.serverinfo.ServerInfoScene;
import pro.gravit.launcher.gui.scenes.servermenu.ServerMenuScene;
import pro.gravit.launcher.gui.scenes.settings.SettingsScene;
import pro.gravit.utils.helper.LogHelper;

public class GuiEventHandler
implements RequestService.EventHandler {
    private final JavaFXApplication application;

    public GuiEventHandler(JavaFXApplication application) {
        this.application = application;
    }

    public <T extends WebSocketEvent> boolean eventHandle(T event) {
        block10: {
            LogHelper.dev((String)"Processing event %s", (Object[])new Object[]{event.getType()});
            if (event instanceof RequestEvent) {
                RequestEvent requestEvent = (RequestEvent)event;
                if (!requestEvent.requestUUID.equals(RequestEvent.eventUUID)) {
                    return false;
                }
            }
            try {
                AbstractScene scene;
                if (event instanceof AuthRequestEvent) {
                    AuthRequestEvent authRequestEvent = (AuthRequestEvent)event;
                    boolean isNextScene = this.application.getCurrentScene() instanceof LoginScene;
                    LogHelper.dev((String)"Receive auth event. Send next scene %s", (Object[])new Object[]{isNextScene ? "true" : "false"});
                    this.application.authService.setAuthResult(null, authRequestEvent);
                    if (isNextScene) {
                        Platform.runLater(() -> {
                            try {
                                ((LoginScene)this.application.getCurrentScene()).onSuccessLogin(new AuthFlow.SuccessAuth(authRequestEvent, authRequestEvent.playerProfile != null ? authRequestEvent.playerProfile.username : null, null));
                            }
                            catch (Throwable e) {
                                LogHelper.error((Throwable)e);
                            }
                        });
                    }
                }
                if (!(event instanceof ProfilesRequestEvent)) break block10;
                ProfilesRequestEvent profilesRequestEvent = (ProfilesRequestEvent)event;
                this.application.profilesService.setProfilesResult(profilesRequestEvent);
                if (this.application.profilesService.getProfile() != null) {
                    UUID profileUUID = this.application.profilesService.getProfile().getUUID();
                    for (ClientProfile profile : this.application.profilesService.getProfiles()) {
                        if (!profile.getUUID().equals(profileUUID)) continue;
                        this.application.profilesService.setProfile(profile);
                        break;
                    }
                }
                if (!((scene = this.application.getCurrentScene()) instanceof ServerMenuScene) && !(scene instanceof ServerInfoScene)) {
                    if (!(scene instanceof SettingsScene | scene instanceof OptionsScene)) break block10;
                }
                scene.contextHelper.runInFxThread(scene::reset);
            }
            catch (Throwable e) {
                LogHelper.error((Throwable)e);
            }
        }
        return false;
    }
}

