/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.impl;

import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.effect.Effect;
import javafx.scene.effect.GaussianBlur;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Rectangle;
import javafx.stage.Stage;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.impl.AbstractVisualComponent;
import pro.gravit.launcher.gui.utils.JavaFxUtils;
import pro.gravit.utils.helper.LogHelper;

public abstract class AbstractStage {
    protected final JavaFXApplication application;
    protected final Stage stage;
    protected final Scene scene;
    protected final StackPane stackPane;
    protected AbstractVisualComponent visualComponent;
    protected AbstractVisualComponent background;
    protected Pane disablePane;
    protected VBox notificationsVBox;
    protected AnchorPane notifications;
    private final AtomicInteger disableCounter = new AtomicInteger(0);
    protected final AtomicInteger scenePosition = new AtomicInteger(0);
    protected List<String> sceneFlow = new LinkedList<String>();

    protected AbstractStage(JavaFXApplication application, Stage stage) {
        this.application = application;
        this.stage = stage;
        this.stackPane = new StackPane();
        this.scene = new Scene((Parent)this.stackPane);
        this.stage.setScene(this.scene);
        this.resetStyles();
    }

    protected void setClipRadius(double width, double height) {
        Rectangle rect = new Rectangle(this.stackPane.getPrefWidth(), this.stackPane.getPrefHeight());
        rect.heightProperty().bind((ObservableValue)this.stackPane.heightProperty());
        rect.widthProperty().bind((ObservableValue)this.stackPane.widthProperty());
        rect.setArcHeight(height);
        rect.setArcWidth(width);
        this.stackPane.setClip((Node)rect);
    }

    public void hide() {
        this.stage.setIconified(true);
    }

    public void close() {
        this.stage.hide();
    }

    public void resetStyles() {
        try {
            this.scene.getStylesheets().clear();
            this.scene.getStylesheets().add((Object)JavaFxUtils.getStyleUrl("styles/variables").toString());
            this.scene.getStylesheets().add((Object)JavaFxUtils.getStyleUrl("styles/global").toString());
        }
        catch (IOException e) {
            LogHelper.error((Throwable)e);
        }
    }

    public void enableMouseDrag(Node node) {
        AtomicReference movePoint = new AtomicReference();
        node.setOnMousePressed(event -> movePoint.set(new Point2D(event.getSceneX(), event.getSceneY())));
        node.setOnMouseDragged(event -> {
            if (movePoint.get() == null) {
                return;
            }
            this.stage.setX(event.getScreenX() - ((Point2D)movePoint.get()).getX());
            this.stage.setY(event.getScreenY() - ((Point2D)movePoint.get()).getY());
        });
    }

    public AbstractVisualComponent getVisualComponent() {
        return this.visualComponent;
    }

    public void setScene(AbstractVisualComponent visualComponent, boolean addToFlow) throws Exception {
        if (visualComponent == null) {
            if (!this.stackPane.getChildren().isEmpty()) {
                this.stackPane.getChildren().set(this.scenePosition.get(), (Object)new Pane());
            }
            return;
        }
        if (addToFlow) {
            this.sceneFlow.add(visualComponent.getName());
        }
        visualComponent.currentStage = this;
        if (!visualComponent.isInit()) {
            visualComponent.init();
        }
        if (visualComponent.isResetOnShow) {
            visualComponent.reset();
        }
        if (this.stackPane.getChildren().isEmpty()) {
            this.stackPane.getChildren().add((Object)visualComponent.getFxmlRoot());
        } else {
            Node old = (Node)this.stackPane.getChildren().get(this.scenePosition.get());
            Effect effect = old.getEffect();
            if (effect instanceof GaussianBlur) {
                GaussianBlur blur = (GaussianBlur)effect;
                old.setEffect(null);
                visualComponent.getFxmlRootPrivate().setEffect((Effect)blur);
            }
            this.stackPane.getChildren().set(this.scenePosition.get(), (Object)visualComponent.getFxmlRoot());
        }
        this.stage.sizeToScene();
        visualComponent.postInit();
        this.visualComponent = visualComponent;
    }

    public AbstractVisualComponent back() throws Exception {
        AbstractVisualComponent component;
        if (this.sceneFlow.size() <= 1) {
            return null;
        }
        do {
            String name;
            if ((component = this.application.gui.getByName(name = this.sceneFlow.get(this.sceneFlow.size() - 2))) == null) {
                return null;
            }
            this.sceneFlow.remove(this.sceneFlow.get(this.sceneFlow.size() - 1));
        } while (component.isDisableReturnBack());
        this.setScene(component, false);
        return component;
    }

    public void push(Node node) {
        this.stackPane.getChildren().add((Object)node);
    }

    public boolean contains(Node node) {
        return this.stackPane.getChildren().contains((Object)node);
    }

    public void pull(Node node) {
        this.stackPane.getChildren().remove((Object)node);
    }

    public void addAfter(Node node, Node value) {
        int index = this.stackPane.getChildren().indexOf((Object)node);
        if (index >= 0) {
            this.stackPane.getChildren().add(index + 1, (Object)value);
        }
    }

    public void addBefore(Node node, Node value) {
        int index = this.stackPane.getChildren().indexOf((Object)node);
        if (index >= 0) {
            this.stackPane.getChildren().add(index, (Object)value);
        }
    }

    public int getScenePosition() {
        return this.scenePosition.get();
    }

    protected void pushNotification(Node node) {
        if (this.notifications == null) {
            this.notifications = new AnchorPane();
            this.notificationsVBox = new VBox();
            this.notificationsVBox.setAlignment(Pos.BOTTOM_RIGHT);
            this.notifications.setPickOnBounds(false);
            this.notificationsVBox.setPickOnBounds(false);
            this.notifications.getChildren().add((Object)this.notificationsVBox);
            AnchorPane.setRightAnchor((Node)this.notificationsVBox, (Double)10.0);
            AnchorPane.setTopAnchor((Node)this.notificationsVBox, (Double)10.0);
            AnchorPane.setBottomAnchor((Node)this.notificationsVBox, (Double)10.0);
            this.notificationsVBox.setSpacing(10.0);
            this.push((Node)this.notifications);
        }
        this.notificationsVBox.getChildren().add((Object)node);
    }

    protected void pullNotification(Node node) {
        if (this.notifications != null) {
            this.notificationsVBox.getChildren().remove((Object)node);
        }
    }

    public boolean isShowing() {
        return this.stage.isShowing();
    }

    public final boolean isNullScene() {
        return this.visualComponent == null;
    }

    public Stage getStage() {
        return this.stage;
    }

    public void show() {
        this.stage.show();
    }

    public void disable() {
        int value = this.disableCounter.incrementAndGet();
        LogHelper.dev((String)"Disable scene: stack_num: %s | blur: %s | counter: %s", (Object[])new Object[]{this.stackPane.getChildren().size(), this.disablePane == null ? "null" : "not null", value});
        if (value != 1) {
            return;
        }
        Pane layout = (Pane)this.stackPane.getChildren().get(this.scenePosition.get());
        layout.setEffect((Effect)new GaussianBlur(150.0));
        if (this.disablePane == null) {
            this.disablePane = new Pane();
            this.disablePane.setPrefHeight(layout.getPrefHeight());
            this.disablePane.setPrefWidth(layout.getPrefWidth());
            this.addAfter((Node)layout, (Node)this.disablePane);
        }
        this.disablePane.setVisible(true);
    }

    public void enable() {
        int value = this.disableCounter.decrementAndGet();
        LogHelper.dev((String)"Enable scene: stack_num: %s | blur: %s | counter: %s", (Object[])new Object[]{this.stackPane.getChildren().size(), this.disablePane == null ? "null" : "not null", value});
        if (value != 0) {
            return;
        }
        Pane layout = (Pane)this.stackPane.getChildren().get(this.scenePosition.get());
        layout.setEffect(null);
        this.disablePane.setVisible(false);
    }
}

