/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.dialogs;

import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.dialogs.AbstractDialog;
import pro.gravit.launcher.gui.helper.LookupHelper;

public class ApplyDialog
extends AbstractDialog {
    private String header;
    private String text;
    private final Runnable onAccept;
    private final Runnable onDeny;
    private final Runnable onClose;
    private Label textHeader;
    private Label textDescription;

    public ApplyDialog(JavaFXApplication application, String header, String text, Runnable onAccept, Runnable onDeny, Runnable onClose) {
        super("dialogs/apply/dialog.fxml", application);
        this.header = header;
        this.text = text;
        this.onAccept = onAccept;
        this.onDeny = onDeny;
        this.onClose = onClose;
    }

    public void setHeader(String header) {
        this.header = header;
        if (this.isInit()) {
            this.textDescription.setText(this.text);
        }
    }

    public void setText(String text) {
        this.text = text;
        if (this.isInit()) {
            this.textHeader.setText(this.header);
        }
    }

    @Override
    public String getName() {
        return "apply";
    }

    @Override
    protected void doInit() {
        this.textHeader = (Label)LookupHelper.lookup((Node)this.layout, "#headingDialog");
        this.textDescription = (Label)LookupHelper.lookup((Node)this.layout, "#textDialog");
        this.textHeader.setText(this.header);
        this.textDescription.setText(this.text);
        ((Button)LookupHelper.lookup((Node)this.layout, "#close")).setOnAction(e -> {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                this.errorHandle(throwable);
            }
            this.onClose.run();
        });
        ((Button)LookupHelper.lookup((Node)this.layout, "#apply")).setOnAction(e -> {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                this.errorHandle(throwable);
            }
            this.onAccept.run();
        });
        ((Button)LookupHelper.lookup((Node)this.layout, "#deny")).setOnAction(e -> {
            try {
                this.close();
            }
            catch (Throwable throwable) {
                this.errorHandle(throwable);
            }
            this.onDeny.run();
        });
    }
}

