/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui.commands.runtime;

import java.util.ArrayList;
import javafx.application.ConditionalFeature;
import javafx.application.Platform;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.utils.command.Command;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.LogHelper;

public class InfoCommand
extends Command {
    private final JavaFXApplication application;

    public InfoCommand(JavaFXApplication application) {
        this.application = application;
    }

    public String getArgsDescription() {
        return "[]";
    }

    public String getUsageDescription() {
        return "show javafx info";
    }

    public void invoke(String ... args) {
        Platform.runLater(() -> {
            LogHelper.info((String)"OS %s ARCH %s Java %d", (Object[])new Object[]{JVMHelper.OS_TYPE.name(), JVMHelper.ARCH_TYPE.name(), JVMHelper.JVM_VERSION});
            LogHelper.info((String)"JavaFX version: %s", (Object[])new Object[]{System.getProperty("javafx.runtime.version")});
            ArrayList<String> supportedFeatures = new ArrayList<String>();
            ArrayList<String> unsupportedFeatures = new ArrayList<String>();
            for (ConditionalFeature e : ConditionalFeature.values()) {
                if (Platform.isSupported((ConditionalFeature)e)) {
                    supportedFeatures.add(e.name());
                    continue;
                }
                unsupportedFeatures.add(e.name());
            }
            LogHelper.info((String)"JavaFX supported features: [%s]", (Object[])new Object[]{String.join((CharSequence)",", supportedFeatures)});
            LogHelper.info((String)"JavaFX unsupported features: [%s]", (Object[])new Object[]{String.join((CharSequence)",", unsupportedFeatures)});
            LogHelper.info((String)"Is accessibility active %s", (Object[])new Object[]{Platform.isAccessibilityActive() ? "true" : "false"});
        });
    }
}

