/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.gui;

import java.io.IOException;
import java.security.interfaces.ECPrivateKey;
import java.util.concurrent.CompletableFuture;
import pro.gravit.launcher.base.request.Request;
import pro.gravit.launcher.base.request.secure.GetSecureLevelInfoRequest;
import pro.gravit.launcher.base.request.secure.HardwareReportRequest;
import pro.gravit.launcher.base.request.secure.VerifySecureLevelKeyRequest;
import pro.gravit.launcher.gui.JavaFXApplication;
import pro.gravit.launcher.gui.JavaRuntimeModule;
import pro.gravit.launcher.runtime.utils.HWIDProvider;
import pro.gravit.utils.helper.CommonHelper;
import pro.gravit.utils.helper.LogHelper;
import pro.gravit.utils.helper.SecurityHelper;

public class RuntimeSecurityService {
    private final JavaFXApplication application;
    private final Boolean[] waitObject = new Boolean[]{null};

    public RuntimeSecurityService(JavaFXApplication application) {
        this.application = application;
    }

    public void startRequest() throws IOException {
        ((CompletableFuture)this.application.service.request((Request)new GetSecureLevelInfoRequest()).thenAccept(event -> {
            if (!event.enabled || event.verifySecureKey == null) {
                LogHelper.info((String)"Advanced security level disabled");
                this.notifyWaitObject(false);
                return;
            }
            byte[] signature = this.sign(event.verifySecureKey);
            try {
                ((CompletableFuture)this.application.service.request((Request)new VerifySecureLevelKeyRequest(JavaRuntimeModule.engine.publicKey.getEncoded(), signature)).thenAccept(event1 -> {
                    if (!event1.needHardwareInfo) {
                        this.simpleGetHardwareToken();
                    } else {
                        this.doCollectHardwareInfo(!event1.onlyStatisticInfo);
                    }
                })).exceptionally(e -> {
                    this.application.messageManager.createNotification("Hardware Checker", e.getCause().getMessage());
                    this.notifyWaitObject(false);
                    return null;
                });
            }
            catch (IOException e2) {
                LogHelper.error((String)"VerifySecureLevel failed: %s", (Object[])new Object[]{e2.getMessage()});
                this.notifyWaitObject(false);
            }
        })).exceptionally(e -> {
            LogHelper.info((String)"Advanced security level disabled(exception)");
            this.notifyWaitObject(false);
            return null;
        });
    }

    private void simpleGetHardwareToken() {
        try {
            ((CompletableFuture)this.application.service.request((Request)new HardwareReportRequest()).thenAccept(response -> {
                LogHelper.info((String)"Advanced security level success completed");
                this.notifyWaitObject(true);
            })).exceptionally(e -> {
                this.application.messageManager.createNotification("Hardware Checker", e.getCause().getMessage());
                this.notifyWaitObject(false);
                return null;
            });
        }
        catch (IOException e2) {
            this.application.messageManager.createNotification("Hardware Checker", e2.getCause().getMessage());
            this.notifyWaitObject(false);
        }
    }

    private void doCollectHardwareInfo(boolean needSerial) {
        CommonHelper.newThread((String)"HardwareInfo Collector Thread", (boolean)true, () -> {
            try {
                HWIDProvider provider = new HWIDProvider();
                HardwareReportRequest.HardwareInfo info = provider.getHardwareInfo(needSerial);
                HardwareReportRequest reportRequest = new HardwareReportRequest();
                reportRequest.hardware = info;
                ((CompletableFuture)this.application.service.request((Request)reportRequest).thenAccept(event -> {
                    LogHelper.info((String)"Advanced security level success completed");
                    this.notifyWaitObject(true);
                })).exceptionally(exc -> {
                    this.application.messageManager.createNotification("Hardware Checker", exc.getCause().getMessage());
                    return null;
                });
            }
            catch (Throwable e) {
                LogHelper.error((Throwable)e);
                this.notifyWaitObject(false);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitObject(boolean state) {
        Boolean[] booleanArray = this.waitObject;
        synchronized (this.waitObject) {
            this.waitObject[0] = state;
            this.waitObject.notifyAll();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getSecurityState() throws InterruptedException {
        Boolean[] booleanArray = this.waitObject;
        synchronized (this.waitObject) {
            if (this.waitObject[0] == null) {
                this.waitObject.wait(3000L);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.waitObject[0];
        }
    }

    public byte[] sign(byte[] data) {
        return SecurityHelper.sign((byte[])data, (ECPrivateKey)JavaRuntimeModule.engine.privateKey);
    }
}

