/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.structure;

import com.robertx22.dungeon_realm.database.holders.DungeonBonusContents;
import com.robertx22.dungeon_realm.database.holders.DungeonRelicStats;
import com.robertx22.dungeon_realm.item.DungeonItemMapData;
import com.robertx22.dungeon_realm.item.DungeonItemNbt;
import com.robertx22.dungeon_realm.structure.BonusContentData;
import com.robertx22.library_of_exile.components.LibMapData;
import com.robertx22.library_of_exile.database.extra_map_content.MapContent;
import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.database.relic.stat.ContentWeightRS;
import com.robertx22.library_of_exile.database.relic.stat.ExtraContentRS;
import com.robertx22.library_of_exile.database.relic.stat.RelicStat;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import com.robertx22.library_of_exile.util.PointData;
import com.robertx22.library_of_exile.util.Weighted;
import com.robertx22.library_of_exile.utils.RandomUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;

public class MapBonusContentsData {
    HashMap<String, BonusContentData> map = new HashMap();
    public int totalGenDungeonChunks = 0;
    public int processedChunks = 0;
    public Set<PointData> mechsChunks = new HashSet<PointData>();

    public float calcSpawnChance(BlockPos pos) {
        ChunkPos cp = new ChunkPos(pos);
        PointData point = new PointData(cp.f_45578_, cp.f_45579_);
        if (this.mechsChunks.contains(point)) {
            return 0.0f;
        }
        int chunksLeft = this.totalGenDungeonChunks - this.processedChunks;
        int remaining = this.getTotalSpawnsRemainingFromAllContents();
        if (chunksLeft < remaining) {
            return 100.0f;
        }
        float chance = (float)remaining / (float)chunksLeft * 100.0f;
        return chance;
    }

    public int getTotalSpawnsRemainingFromAllContents() {
        return this.map.values().stream().mapToInt(x -> x.remainingSpawns).sum();
    }

    void addContent(MapContent c, LibMapData libdata) {
        ExtraContentRS extra;
        int amount = RandomUtils.RandomRange((int)c.min_blocks, (int)c.max_blocks);
        for (RelicStat stat : LibDatabase.RelicStats().getList()) {
            if (!(stat instanceof ExtraContentRS)) continue;
            extra = (ExtraContentRS)stat;
            if (extra.data.type() != ExtraContentRS.Type.ADDITION || !extra.data.map_content_id().equals(c.GUID()) || !RandomUtils.roll((float)libdata.relicStats.get(stat))) continue;
            amount += extra.data.extra();
        }
        for (RelicStat stat : LibDatabase.RelicStats().getList()) {
            if (!(stat instanceof ExtraContentRS)) continue;
            extra = (ExtraContentRS)stat;
            if (extra.data.type() != ExtraContentRS.Type.MULTIPLY || !extra.data.map_content_id().equals(c.GUID()) || !RandomUtils.roll((float)libdata.relicStats.get(stat))) continue;
            amount *= extra.data.extra();
        }
        BonusContentData data = new BonusContentData(amount);
        this.map.put(c.GUID(), data);
    }

    public void setupOnMapStart(ItemStack stack, LibMapData libdata, Player p) {
        List possible;
        DungeonItemMapData map = (DungeonItemMapData)DungeonItemNbt.DUNGEON_MAP.loadFrom(stack);
        for (MapContent c : LibDatabase.MapContent().getFiltered(x -> x.always_spawn)) {
            this.addContent(c, libdata);
        }
        int bonus = map.bonus_contents;
        if (RandomUtils.roll((float)libdata.relicStats.get(DungeonRelicStats.INSTANCE.BONUS_CONTENT_CHANCE))) {
            ++bonus;
        }
        if (bonus > (possible = LibDatabase.MapContent().getFiltered(x -> !x.always_spawn && x.Weight() > 0).stream().map(e -> {
            int weight = e.weight;
            for (RelicStat stat : LibDatabase.RelicStats().getList()) {
                if (!(stat instanceof ContentWeightRS)) continue;
                ContentWeightRS cw = (ContentWeightRS)stat;
                if (!cw.map_content_id.equals(e.GUID())) continue;
                weight = (int)((float)weight * (1.0f + libdata.relicStats.get((RelicStat)cw) / 100.0f));
            }
            return new Weighted(e, weight);
        }).collect(Collectors.toList())).size()) {
            bonus = possible.size();
        }
        for (int i = 0; i < bonus; ++i) {
            MapContent c = (MapContent)((Weighted)RandomUtils.weightedRandom(possible)).obj;
            this.addContent(c, libdata);
            possible.removeIf(x -> ((MapContent)x.obj).GUID().equals(c.GUID()));
        }
        if (map.uber) {
            this.addContent((MapContent)DungeonBonusContents.INSTANCE.UBER_BOSS.get(), libdata);
        }
    }

    public BonusContentData get(MapStructure m) {
        return this.map.getOrDefault(m.guid(), BonusContentData.EMPTY);
    }
}

