/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.structure;

import com.robertx22.dungeon_realm.configs.DungeonConfig;
import com.robertx22.dungeon_realm.database.DungeonDatabase;
import com.robertx22.dungeon_realm.database.dungeon.Dungeon;
import com.robertx22.library_of_exile.dimension.MapGenerationUTIL;
import com.robertx22.library_of_exile.dimension.structure.dungeon.DungeonBuilder;
import com.robertx22.library_of_exile.dimension.structure.dungeon.DungeonStructure;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.world.level.ChunkPos;

public class DungeonMapStructure
extends DungeonStructure {
    public static int DUNGEON_LENGTH = 30;

    public String guid() {
        return "dungeon";
    }

    public DungeonBuilder getMap(ChunkPos cp) {
        ChunkPos start = this.getStartChunkPos(cp);
        DungeonBuilder b = new DungeonBuilder(DungeonMapStructure.dungeonSettings(start));
        return b;
    }

    public static DungeonBuilder.Settings dungeonSettings(ChunkPos pos) {
        DungeonBuilder.Settings settings = new DungeonBuilder.Settings(MapGenerationUTIL.createRandom((ChunkPos)pos), ((Integer)DungeonConfig.get().MIN_MAP_ROOMS.get()).intValue(), ((Integer)DungeonConfig.get().MAX_MAP_ROOMS.get()).intValue(), DungeonDatabase.Dungeons().getFilterWrapped((Predicate<Dungeon>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$dungeonSettings$0(com.robertx22.dungeon_realm.database.dungeon.Dungeon ), (Lcom/robertx22/dungeon_realm/database/dungeon/Dungeon;)Z)()).list.stream().collect(Collectors.toList()));
        return settings;
    }

    public ChunkPos getStartFromCounter(int x, int z) {
        ChunkPos start = new ChunkPos(x * DUNGEON_LENGTH, z * DUNGEON_LENGTH);
        start = this.getStartChunkPos(start);
        return start;
    }

    public int getSpawnHeight() {
        return 50;
    }

    protected ChunkPos INTERNALgetStartChunkPos(ChunkPos cp) {
        int chunkX = cp.f_45578_;
        int chunkZ = cp.f_45579_;
        int distToEntranceX = 11 - chunkX % DUNGEON_LENGTH;
        int distToEntranceZ = 11 - chunkZ % DUNGEON_LENGTH;
        return new ChunkPos(chunkX += distToEntranceX, chunkZ += distToEntranceZ);
    }

    private static /* synthetic */ boolean lambda$dungeonSettings$0(Dungeon x) {
        return true;
    }
}

