/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.structure;

import com.robertx22.dungeon_realm.configs.DungeonConfig;
import com.robertx22.dungeon_realm.item.DungeonItemMapData;
import com.robertx22.dungeon_realm.main.DungeonMain;
import com.robertx22.dungeon_realm.main.DungeonWords;
import com.robertx22.dungeon_realm.structure.BonusContentData;
import com.robertx22.dungeon_realm.structure.MapBonusContentsData;
import com.robertx22.dungeon_realm.structure.MobSpawnBlockKind;
import com.robertx22.library_of_exile.database.extra_map_content.MapContent;
import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.database.map_finish_rarity.MapFinishRarity;
import com.robertx22.library_of_exile.localization.TranslationType;
import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.utils.RandomUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class DungeonMapData {
    public MapBonusContentsData bonusContents = new MapBonusContentsData();
    public HashMap<String, Long> spawnPositions = new HashMap();
    public DungeonItemMapData item = new DungeonItemMapData();
    public int x = 0;
    public int z = 0;
    public String current_mob_kill_rarity = "common";
    public int mobDataBlockCount = 0;
    public int packDataBlockCount = 0;
    public int eliteDataBlockCount = 0;
    public int elitePackDataBlockCount = 0;
    public int miniBossDataBlockCount = 0;
    public int processedMobDataBlockCount = 0;
    public int processedPackDataBlockCount = 0;
    public int processedEliteDataBlockCount = 0;
    public int processedElitePackDataBlockCount = 0;
    public int processedMiniBossDataBlockCount = 0;
    public int mobSpawnCount = 0;
    public int eliteSpawnCount = 0;
    public int miniBossSpawnCount = 0;
    public int mobKills = 0;
    public int eliteKills = 0;
    public int miniBossKills = 0;
    public int totalChests = 0;
    public int lootedChests = 0;

    private int mobBlocksLeftToProcess() {
        return this.mobDataBlockCount - this.processedMobDataBlockCount;
    }

    private int packBlocksLeftToProcess() {
        return this.packDataBlockCount - this.processedPackDataBlockCount;
    }

    private int eliteBlocksLeftToProcess() {
        return this.eliteDataBlockCount - this.processedEliteDataBlockCount;
    }

    private int elitePackBlocksLeftToProcess() {
        return this.elitePackDataBlockCount - this.processedElitePackDataBlockCount;
    }

    private int miniBossBlocksLeftToProcess() {
        return this.miniBossDataBlockCount - this.processedMiniBossDataBlockCount;
    }

    public MapFinishRarity getFinishRarity() {
        return (MapFinishRarity)LibDatabase.MapFinishRarity().get(this.current_mob_kill_rarity);
    }

    public void incrementSpawnBlockCountByKind(MobSpawnBlockKind kind) {
        kind.incrementDataBlockCount(this);
    }

    public void spawnBonusMapContent(Level level, BlockPos pos) {
        List list;
        if (DungeonMain.MAIN_DUNGEON_STRUCTURE.isInside((ServerLevel)level, pos) && (list = this.bonusContents.map.entrySet().stream().filter(x -> ((BonusContentData)x.getValue()).remainingSpawns > 0).collect(Collectors.toList())).size() > 0) {
            Map.Entry en = (Map.Entry)RandomUtils.randomFromList(list);
            MapContent mc = (MapContent)LibDatabase.MapContent().get((String)en.getKey());
            Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(mc.block_id));
            level.m_7731_(pos, block.m_49966_(), 3);
            --this.bonusContents.map.get(en.getKey()).remainingSpawns;
        }
    }

    private String showMapData() {
        Object result = "";
        result = (String)result + "mobCommandBlockCount: (" + this.processedMobDataBlockCount + "/" + this.mobDataBlockCount + ")\n";
        result = (String)result + "packCommandBlockCount: (" + this.processedPackDataBlockCount + "/" + this.packDataBlockCount + ")\n";
        result = (String)result + "eliteCommandBlockCount: (" + this.processedEliteDataBlockCount + "/" + this.eliteDataBlockCount + ")\n";
        result = (String)result + "elitePackCommandBlockCount: (" + this.processedElitePackDataBlockCount + "/" + this.elitePackDataBlockCount + ")\n";
        result = (String)result + "miniBossCommandBlockCount: (" + this.processedMiniBossDataBlockCount + "/" + this.miniBossDataBlockCount + ")\n";
        result = (String)result + "mobSpawnCount: " + this.mobSpawnCount + "\n";
        result = (String)result + "eliteSpawnCount: " + this.eliteSpawnCount + "\n";
        result = (String)result + "mobKills: " + this.mobKills + "\n";
        result = (String)result + "eliteKills: " + this.eliteKills + "\n";
        result = (String)result + "miniBossKills: " + this.miniBossKills + "\n";
        result = (String)result + "totalChests: " + this.totalChests + "\n";
        result = (String)result + "lootedChests: " + this.lootedChests + "\n";
        return result;
    }

    private int calculateKillCompletionPercent() {
        int ELITE_KILL_WEIGHT = (Integer)DungeonConfig.get().ELITE_MOB_COMPLETION_WEIGHT.get();
        int MINI_BOSS_KILL_WEIGHT = (Integer)DungeonConfig.get().MINI_BOSS_COMPLETION_WEIGHT.get();
        int KILL_COMPLETION_DATA_BLOCK_LEEWAY = (Integer)DungeonConfig.get().KILL_COMPLETION_DATA_BLOCK_LEEWAY.get();
        if (this.mobBlocksLeftToProcess() + this.packBlocksLeftToProcess() + this.eliteBlocksLeftToProcess() + this.elitePackBlocksLeftToProcess() + this.miniBossBlocksLeftToProcess() - KILL_COMPLETION_DATA_BLOCK_LEEWAY <= 0) {
            int totalPossibleWeightedKills = this.mobSpawnCount + this.eliteSpawnCount * ELITE_KILL_WEIGHT + this.miniBossSpawnCount * MINI_BOSS_KILL_WEIGHT;
            int actualWeightedKills = this.mobKills + this.eliteKills * ELITE_KILL_WEIGHT + this.miniBossKills * MINI_BOSS_KILL_WEIGHT;
            if (totalPossibleWeightedKills == 0) {
                return 0;
            }
            float percentage = (float)actualWeightedKills / (float)totalPossibleWeightedKills * 100.0f;
            int rounded = Math.round(percentage);
            return Math.min(rounded, 100);
        }
        int maxMobsLeft = this.mobBlocksLeftToProcess() * (Integer)DungeonConfig.get().MOB_MAX.get() + this.packBlocksLeftToProcess() * (Integer)DungeonConfig.get().PACK_MOB_MAX.get() + this.eliteBlocksLeftToProcess() * ELITE_KILL_WEIGHT + this.elitePackBlocksLeftToProcess() * (Integer)DungeonConfig.get().PACK_MOB_MAX.get() * ELITE_KILL_WEIGHT + this.miniBossBlocksLeftToProcess() * MINI_BOSS_KILL_WEIGHT;
        int totalPossibleWeightedKills = this.mobSpawnCount + this.eliteSpawnCount * ELITE_KILL_WEIGHT + maxMobsLeft;
        int actualWeightedKills = this.mobKills + this.eliteKills * ELITE_KILL_WEIGHT;
        if (totalPossibleWeightedKills == 0) {
            return 0;
        }
        float percentage = (float)actualWeightedKills / (float)totalPossibleWeightedKills * 100.0f;
        int rounded = Math.round(percentage);
        return Math.min(rounded, 100);
    }

    private int calculateLootCompletionPercent() {
        if (this.totalChests == 0) {
            return 0;
        }
        float percentage = (float)this.lootedChests / (float)this.totalChests * 100.0f;
        int rounded = Math.round(percentage);
        return Math.min(rounded, 100);
    }

    public void updateMapCompletionRarity(ServerPlayer player) {
        int killCompletionPercent = this.calculateKillCompletionPercent();
        ExileLog.get().debug(this.showMapData(), new Object[0]);
        MapFinishRarity rar = (MapFinishRarity)LibDatabase.MapFinishRarity().get(this.current_mob_kill_rarity);
        if (rar.getHigher().isPresent()) {
            MapFinishRarity higher = (MapFinishRarity)rar.getHigher().get();
            if (killCompletionPercent >= higher.perc_to_unlock) {
                this.current_mob_kill_rarity = higher.GUID();
                for (Player p : DungeonMain.MAIN_DUNGEON_STRUCTURE.getAllPlayersInMap(player.m_9236_(), player.m_20183_())) {
                    MutableComponent rartext = this.getFinishRarity().getTranslation(TranslationType.NAME).getTranslatedName(new Object[0]).m_130940_(this.getFinishRarity().textFormatting());
                    p.m_213846_((Component)DungeonWords.MAP_COMPLETE_RARITY_UPGRADE.get(rartext).m_130940_(ChatFormatting.LIGHT_PURPLE));
                }
            }
        }
    }
}

