/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.main;

import com.robertx22.dungeon_realm.block.CustomSpawnTpBlock;
import com.robertx22.dungeon_realm.capability.DungeonEntityCapability;
import com.robertx22.dungeon_realm.configs.DungeonConfig;
import com.robertx22.dungeon_realm.database.holders.DungeonMapBlocks;
import com.robertx22.dungeon_realm.database.holders.DungeonRelicStats;
import com.robertx22.dungeon_realm.item.DungeonMapGenSettings;
import com.robertx22.dungeon_realm.item.DungeonMapItem;
import com.robertx22.dungeon_realm.item.relic.RelicGenerator;
import com.robertx22.dungeon_realm.main.DataBlockTags;
import com.robertx22.dungeon_realm.main.DungeonEntries;
import com.robertx22.dungeon_realm.main.DungeonMain;
import com.robertx22.dungeon_realm.structure.DungeonMapCapability;
import com.robertx22.dungeon_realm.structure.DungeonMapData;
import com.robertx22.dungeon_realm.structure.MobSpawnBlockKind;
import com.robertx22.library_of_exile.components.LibMapCap;
import com.robertx22.library_of_exile.components.LibMapData;
import com.robertx22.library_of_exile.components.LibMapDataSaver;
import com.robertx22.library_of_exile.database.relic.stat.RelicStat;
import com.robertx22.library_of_exile.dimension.MapDimensions;
import com.robertx22.library_of_exile.dimension.structure.MapStructure;
import com.robertx22.library_of_exile.dimension.structure.dungeon.DungeonBuilder;
import com.robertx22.library_of_exile.events.base.EventConsumer;
import com.robertx22.library_of_exile.events.base.ExileEvents;
import com.robertx22.library_of_exile.main.ApiForgeEvents;
import com.robertx22.library_of_exile.main.ExileLog;
import com.robertx22.library_of_exile.util.PointData;
import com.robertx22.library_of_exile.utils.RandomUtils;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class DungeonEvents {
    public static void init() {
        ExileEvents.GRAB_LIB_MAP_DATA.register((EventConsumer)new EventConsumer<ExileEvents.GrabLibMapData>(){

            public void accept(ExileEvents.GrabLibMapData event) {
                DungeonMain.ifMapData(event.level, event.pos).ifPresent(x -> {
                    LibMapDataSaver cap = LibMapCap.get((Level)event.level).data;
                    event.data = (LibMapData)cap.getData((MapStructure)DungeonMain.MAIN_DUNGEON_STRUCTURE, event.pos);
                });
            }
        });
        ApiForgeEvents.registerForgeEvent(LivingDeathEvent.class, event -> {
            if (event.getEntity().m_9236_().f_46443_) {
                return;
            }
            LivingEntity mob = event.getEntity();
            if (MapDimensions.isMap((Level)mob.m_9236_())) {
                if (DungeonEntityCapability.get((LivingEntity)mob).data.isFinalMapBoss && MapDimensions.isMap((Level)mob.m_9236_())) {
                    mob.m_9236_().m_7731_(mob.m_20183_(), ((CustomSpawnTpBlock)((Object)((Object)DungeonEntries.REWARD_TELEPORT.get()))).m_49966_(), 3);
                    DungeonMain.REWARD_ROOM.generateManually((ServerLevel)mob.m_9236_(), mob.m_146902_());
                }
                if (DungeonEntityCapability.get((LivingEntity)mob).data.isDungeonMob) {
                    DungeonMain.ifMapData(mob.m_9236_(), mob.m_20183_()).ifPresent(x -> ++x.mobKills);
                }
                if (DungeonEntityCapability.get((LivingEntity)mob).data.isDungeonEliteMob) {
                    DungeonMain.ifMapData(mob.m_9236_(), mob.m_20183_()).ifPresent(x -> ++x.eliteKills);
                }
                if (DungeonEntityCapability.get((LivingEntity)mob).data.isMiniBossMob) {
                    DungeonMain.ifMapData(mob.m_9236_(), mob.m_20183_()).ifPresent(x -> ++x.miniBossKills);
                }
                if (DungeonEntityCapability.get((LivingEntity)mob).data.isUberBoss) {
                    for (int i = 0; i < 3; ++i) {
                        mob.m_19983_(RelicGenerator.randomRelicItem(Optional.empty(), new RelicGenerator.Settings()));
                    }
                }
                if (DungeonEntityCapability.get((LivingEntity)mob).data.isFinalMapBoss) {
                    Entity patt5140$temp;
                    mob.m_19983_(RelicGenerator.randomRelicItem(Optional.empty(), new RelicGenerator.Settings()));
                    LibMapData data = LibMapCap.getData((Level)mob.m_9236_(), (BlockPos)mob.m_20183_());
                    float chance = ((Double)DungeonConfig.get().UBER_FRAG_DROPRATE.get()).floatValue();
                    if (data != null) {
                        chance *= 1.0f + data.relicStats.get((RelicStat)DungeonRelicStats.INSTANCE.BONUS_BOSS_FRAG_CHANCE.get()) / 100.0f;
                    }
                    if (RandomUtils.roll((float)chance)) {
                        mob.m_19983_(((Item)DungeonEntries.UBER_FRAGMENT.get()).m_7968_());
                    }
                    if ((patt5140$temp = event.getSource().m_7639_()) instanceof Player) {
                        float mapchance;
                        Player p = (Player)patt5140$temp;
                        LibMapData libdata = LibMapCap.getData((Level)mob.m_9236_(), (BlockPos)mob.m_20183_());
                        if (libdata != null && RandomUtils.roll((float)(mapchance = libdata.relicStats.get(DungeonRelicStats.INSTANCE.BONUS_MAP_ITEM_FROM_BOSS_CHANCE)))) {
                            mob.m_19983_(DungeonMapItem.newRandomMapItemStack(new DungeonMapGenSettings()));
                        }
                    }
                }
            }
        });
        ExileEvents.DUNGEON_DATA_BLOCK_PLACED.register((EventConsumer)new EventConsumer<ExileEvents.DungeonDataBlockPlaced>(){

            public void accept(ExileEvents.DungeonDataBlockPlaced event) {
                CompoundTag blockNbt = event.blockInfo.f_74677_();
                if (blockNbt == null) {
                    ExileLog.get().warn("Dungeon Data Block NBT is null", new Object[0]);
                    return;
                }
                String blockMetadata = blockNbt.m_128441_("metadata") ? blockNbt.m_128461_("metadata") : (blockNbt.m_128441_("Command") ? blockNbt.m_128461_("Command") : "unknown");
                ServerLevel serverLevel = event.levelAccessor.m_7654_().m_129880_(ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)DungeonMain.DIMENSION_KEY));
                if (DungeonMain.MAP.isInside((MapStructure)DungeonMain.MAIN_DUNGEON_STRUCTURE, serverLevel, event.pos)) {
                    DungeonMain.ifMapData((Level)serverLevel, event.pos).ifPresent(mapData -> {
                        Optional<MobSpawnBlockKind> mobSpawnBlockKind = DungeonMapBlocks.getMobSpawnBlockKindFromBlockMetadata(blockMetadata);
                        mobSpawnBlockKind.ifPresent(mapData::incrementSpawnBlockCountByKind);
                    });
                }
            }
        });
        ExileEvents.ON_CHEST_LOOTED.register((EventConsumer)new EventConsumer<ExileEvents.OnChestLooted>(){

            public void accept(ExileEvents.OnChestLooted event) {
                if (event.player.m_9236_().f_46443_) {
                    return;
                }
                if (MapDimensions.isMap((Level)event.player.m_9236_())) {
                    DungeonMain.ifMapData(event.player.m_9236_(), event.pos).ifPresent(x -> ++x.lootedChests);
                }
            }
        });
        ExileEvents.PROCESS_CHUNK_DATA.register((EventConsumer)new EventConsumer<ExileEvents.OnProcessChunkData>(){

            public void accept(ExileEvents.OnProcessChunkData event) {
                if (event.struc.guid().equals(DungeonMain.MAIN_DUNGEON_STRUCTURE.guid())) {
                    DungeonMain.ifMapData(event.p.m_9236_(), event.cp.m_151394_(5)).ifPresent(x -> {
                        ++x.bonusContents.processedChunks;
                        if (x.bonusContents.totalGenDungeonChunks < 1) {
                            DungeonBuilder built = DungeonMain.MAIN_DUNGEON_STRUCTURE.getMap(event.cp);
                            built.build();
                            x.bonusContents.totalGenDungeonChunks = built.builtDungeon.amount;
                        }
                    });
                }
            }
        });
        ExileEvents.PROCESS_DATA_BLOCK.register((EventConsumer)new EventConsumer<ExileEvents.OnProcessMapDataBlock>(){

            public void accept(ExileEvents.OnProcessMapDataBlock event) {
                if (event.dataBlock.tags.contains(DataBlockTags.CAN_SPAWN_LEAGUE)) {
                    DungeonEvents.trySpawnLeagueMechanicIfCan(event.world, event.pos);
                }
            }
        });
    }

    public static void trySpawnLeagueMechanicIfCan(Level world, BlockPos pos) {
        DungeonMapData data;
        if (DungeonMain.MAP.isInside((MapStructure)DungeonMain.MAIN_DUNGEON_STRUCTURE, (ServerLevel)world, pos) && (data = (DungeonMapData)DungeonMapCapability.get((Level)world).data.data.getData((MapStructure)DungeonMain.MAIN_DUNGEON_STRUCTURE, pos)) != null) {
            float chance = data.bonusContents.calcSpawnChance(pos);
            if (RandomUtils.roll((float)chance)) {
                data.spawnBonusMapContent(world, pos);
            }
            ChunkPos cp = new ChunkPos(pos);
            PointData point = new PointData(cp.f_45578_, cp.f_45579_);
            data.bonusContents.mechsChunks.add(point);
        }
    }
}

