/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.item.relic;

import com.robertx22.dungeon_realm.item.DungeonItemNbt;
import com.robertx22.dungeon_realm.item.relic.RelicAffixData;
import com.robertx22.dungeon_realm.item.relic.RelicItemData;
import com.robertx22.library_of_exile.database.init.LibDatabase;
import com.robertx22.library_of_exile.database.relic.affix.RelicAffix;
import com.robertx22.library_of_exile.database.relic.relic_rarity.RelicRarity;
import com.robertx22.library_of_exile.database.relic.relic_type.RelicType;
import com.robertx22.library_of_exile.utils.RandomUtils;
import java.util.Optional;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class RelicGenerator {
    public static ItemStack randomRelicItem(Optional<Player> p, Settings settings) {
        RelicItemData data = RelicGenerator.randomRelic(p, settings);
        ItemStack stack = new ItemStack((ItemLike)data.getType().getItem());
        DungeonItemNbt.RELIC.saveTo(stack, (Object)data);
        return stack;
    }

    public static RelicItemData randomRelic(Optional<Player> p, Settings settings) {
        RelicItemData data = new RelicItemData();
        RelicRarity rar = settings.rar.orElse((RelicRarity)LibDatabase.RelicRarities().random());
        RelicType type = settings.type.orElse((RelicType)LibDatabase.RelicTypes().random());
        data.rar = rar.GUID();
        data.type = type.GUID();
        for (int i = 0; i < rar.affixes; ++i) {
            RelicAffix affix = (RelicAffix)LibDatabase.RelicAffixes().getFilterWrapped(x -> {
                if (data.affixes.stream().anyMatch(e -> e.id.equals(x.GUID()))) {
                    return false;
                }
                return type.GUID().equals(x.relic_type);
            }).random();
            int perc = RandomUtils.RandomRange((int)rar.min_affix_percent, (int)rar.max_affix_percent);
            data.affixes.add(new RelicAffixData(affix.GUID(), perc));
        }
        return data;
    }

    public static class Settings {
        public Optional<RelicRarity> rar = Optional.empty();
        public Optional<RelicType> type = Optional.empty();
    }
}

