/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.database.data_blocks.mobs;

import com.robertx22.dungeon_realm.api.DungeonExileEvents;
import com.robertx22.dungeon_realm.api.DungeonMobSpawnedEvent;
import com.robertx22.dungeon_realm.api.PrepareDungeonMobEditsEvent;
import com.robertx22.dungeon_realm.capability.DungeonEntityCapability;
import com.robertx22.dungeon_realm.capability.DungeonEntityData;
import com.robertx22.dungeon_realm.main.DungeonMain;
import com.robertx22.library_of_exile.database.map_data_block.MapDataBlock;
import com.robertx22.library_of_exile.events.base.ExileEvent;
import com.robertx22.library_of_exile.utils.geometry.MyPosition;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;

public class MobBuilder {
    private EntityType type;
    public int amount = 1;
    public DungeonEntityData mobEntityData;
    public Optional<MapDataBlock> dataBlock;
    public List<Consumer<LivingEntity>> mobEdits = new ArrayList<Consumer<LivingEntity>>();

    private MobBuilder() {
    }

    public static MobBuilder of(EntityType type, MapDataBlock block, Consumer<MobBuilder> co) {
        MobBuilder b = new MobBuilder();
        b.type = type;
        b.dataBlock = Optional.ofNullable(block);
        co.accept(b);
        return b;
    }

    public <T extends LivingEntity> List<T> summonMobs(Level world, BlockPos p) {
        ArrayList<T> list = new ArrayList<T>();
        for (int i = 0; i < this.amount; ++i) {
            T mob = this.summon(this.type, world, p);
            list.add(mob);
        }
        DungeonMain.ifMapData(world, p).ifPresent(x -> {
            if (this.mobEntityData.isDungeonMob) {
                x.mobSpawnCount += this.amount;
                if (this.mobEntityData.isPackMob) {
                    ++x.processedPackDataBlockCount;
                } else {
                    ++x.processedMobDataBlockCount;
                }
            } else if (this.mobEntityData.isDungeonEliteMob) {
                x.eliteSpawnCount += this.amount;
                if (this.mobEntityData.isPackMob) {
                    ++x.processedElitePackDataBlockCount;
                } else {
                    ++x.processedEliteDataBlockCount;
                }
            } else if (this.mobEntityData.isMiniBossMob) {
                x.miniBossSpawnCount += this.amount;
                ++x.processedMiniBossDataBlockCount;
            }
        });
        return list;
    }

    private <T extends Mob> T summon(EntityType<T> type, Level world, BlockPos p) {
        MyPosition vec = new MyPosition(p);
        Mob mob = (Mob)type.m_20615_(world);
        mob.m_6518_((ServerLevelAccessor)world, world.m_6436_(p), MobSpawnType.REINFORCEMENT, null, null);
        mob.m_6034_(vec.m_7096_(), vec.m_7098_(), vec.m_7094_());
        PrepareDungeonMobEditsEvent prepare = new PrepareDungeonMobEditsEvent((LivingEntity)mob, this.dataBlock);
        DungeonExileEvents.PREPARE_DUNGEON_MOB_SPAWN.callEvents((ExileEvent)prepare);
        this.mobEdits.addAll(prepare.edits);
        world.m_7967_((Entity)mob);
        for (Consumer<LivingEntity> edit : this.mobEdits) {
            edit.accept((LivingEntity)mob);
        }
        DungeonEntityCapability.get((LivingEntity)mob).data = this.mobEntityData;
        DungeonMobSpawnedEvent afterSpawn = new DungeonMobSpawnedEvent((LivingEntity)mob);
        DungeonExileEvents.DUNGEON_MOB_SPAWNED.callEvents((ExileEvent)afterSpawn);
        return (T)mob;
    }
}

