/*
 * Decompiled with CFR 0.152.
 */
package com.robertx22.dungeon_realm.block_entity;

import com.robertx22.dungeon_realm.item.DungeonItemNbt;
import com.robertx22.dungeon_realm.item.relic.RelicItemData;
import java.util.HashMap;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class MapDeviceMenu
extends AbstractContainerMenu {
    private final Container container;
    private final int containerRows;

    public MapDeviceMenu(int containerId, Inventory playerInventory, Container container, int rows) {
        super(MenuType.f_39959_, containerId);
        int col;
        this.container = container;
        this.containerRows = rows;
        container.m_5856_(playerInventory.f_35978_);
        int containerSlotIndex = 0;
        for (int row = 0; row < rows; ++row) {
            for (col = 0; col < 9; ++col) {
                this.m_38897_(new MapDeviceSlot(container, containerSlotIndex, 8 + col * 18, 18 + row * 18));
                ++containerSlotIndex;
            }
        }
        int playerInventoryY = 103 + (rows - 4) * 18;
        for (int row = 0; row < 3; ++row) {
            for (int col2 = 0; col2 < 9; ++col2) {
                this.m_38897_(new Slot((Container)playerInventory, col2 + row * 9 + 9, 8 + col2 * 18, playerInventoryY + row * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.m_38897_(new Slot((Container)playerInventory, col, 8 + col * 18, playerInventoryY + 58));
        }
    }

    public boolean m_6875_(Player player) {
        return this.container.m_6542_(player);
    }

    public ItemStack m_7648_(Player player, int index) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (index < this.containerRows * 9 ? !this.m_38903_(itemstack1, this.containerRows * 9, this.f_38839_.size(), true) : !this.m_38903_(itemstack1, 0, this.containerRows * 9, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return itemstack;
    }

    public void m_6877_(Player player) {
        super.m_6877_(player);
        this.container.m_5785_(player);
    }

    private static class MapDeviceSlot
    extends Slot {
        public MapDeviceSlot(Container container, int slot, int x, int y) {
            super(container, slot, x, y);
        }

        public boolean m_5857_(ItemStack stack) {
            if (!DungeonItemNbt.RELIC.has(stack)) {
                return false;
            }
            try {
                RelicItemData newRelicData = (RelicItemData)DungeonItemNbt.RELIC.loadFrom(stack);
                return !this.wouldExceedTypeLimit(newRelicData.getType().id, this.getSlotIndex(), stack);
            }
            catch (Exception e) {
                e.printStackTrace();
                return false;
            }
        }

        private boolean wouldExceedTypeLimit(String relicType, int targetSlot, ItemStack newStack) {
            HashMap<String, Integer> typeCount = new HashMap<String, Integer>();
            for (int i = 0; i < this.f_40218_.m_6643_(); ++i) {
                ItemStack existingStack;
                if (i == targetSlot || (existingStack = this.f_40218_.m_8020_(i)).m_41619_() || !DungeonItemNbt.RELIC.has(existingStack)) continue;
                try {
                    RelicItemData existingData = (RelicItemData)DungeonItemNbt.RELIC.loadFrom(existingStack);
                    typeCount.put(existingData.getType().id, typeCount.getOrDefault(existingData.getType().id, 0) + 1);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            int currentCount = typeCount.getOrDefault(relicType, 0);
            try {
                RelicItemData newRelicData = (RelicItemData)DungeonItemNbt.RELIC.loadFrom(newStack);
                return currentCount + 1 > newRelicData.getType().max_equipped;
            }
            catch (Exception e) {
                e.printStackTrace();
                return true;
            }
        }
    }
}

