/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.launcher.base.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import pro.gravit.launcher.CRasHTestlNS2A;
import pro.gravit.launcher.base.events.RequestEvent;
import pro.gravit.launcher.base.events.request.AuthRequestEvent;
import pro.gravit.launcher.base.events.request.AuthRequestEvent$OAuthRequestEvent;
import pro.gravit.launcher.base.events.request.CurrentUserRequestEvent$UserInfo;
import pro.gravit.launcher.base.events.request.RefreshTokenRequestEvent;
import pro.gravit.launcher.base.events.request.RestoreRequestEvent;
import pro.gravit.launcher.base.request.Request$ExtendedToken;
import pro.gravit.launcher.base.request.Request$ExtendedTokenCallback;
import pro.gravit.launcher.base.request.Request$RequestRestoreReport;
import pro.gravit.launcher.base.request.RequestException;
import pro.gravit.launcher.base.request.RequestService;
import pro.gravit.launcher.base.request.WebSocketEvent;
import pro.gravit.launcher.base.request.auth.AuthRequest;
import pro.gravit.launcher.base.request.auth.AuthRequest$ConnectTypes;
import pro.gravit.launcher.base.request.auth.RefreshTokenRequest;
import pro.gravit.launcher.base.request.auth.RestoreRequest;
import pro.gravit.launcher.base.request.auth.password.AuthOAuthPassword;
import pro.gravit.launcher.base.request.websockets.StdWebSocketService;
import pro.gravit.launcher.base.request.websockets.WebSocketRequest;
import pro.gravit.utils.helper.LogHelper;

public abstract class Request<R extends WebSocketEvent>
implements WebSocketRequest {
    private static final List<Request$ExtendedTokenCallback> extendedTokenCallbacks = new ArrayList<Request$ExtendedTokenCallback>(4);
    private static final List<BiConsumer<String, AuthRequestEvent$OAuthRequestEvent>> oauthChangeHandlers = new ArrayList<BiConsumer<String, AuthRequestEvent$OAuthRequestEvent>>(4);
    private static volatile RequestService requestService;
    private static volatile AuthRequestEvent$OAuthRequestEvent oauth;
    private static volatile Map<String, Request$ExtendedToken> extendedTokens;
    private static volatile String authId;
    private static volatile long tokenExpiredTime;
    private static volatile ScheduledExecutorService executorService;
    private static volatile boolean autoRefreshRunning;
    @CRasHTestlNS2A
    public final UUID requestUUID = UUID.randomUUID();
    private final transient AtomicBoolean started = new AtomicBoolean(false);

    public static synchronized void startAutoRefresh() {
        if (!autoRefreshRunning) {
            if (executorService == null) {
                executorService = Executors.newSingleThreadScheduledExecutor(runnable -> {
                    Thread thread = new Thread(runnable);
                    thread.setName("AutoRefresh thread");
                    thread.setDaemon(true);
                    return thread;
                });
            }
            executorService.scheduleAtFixedRate(() -> {
                try {
                    Request.restore(false, true, false);
                }
                catch (Exception exception) {
                    LogHelper.error(exception);
                }
            }, 5L, 5L, TimeUnit.SECONDS);
            autoRefreshRunning = true;
        }
    }

    public static RequestService getRequestService() {
        return requestService;
    }

    public static void setRequestService(RequestService requestService) {
        Request.requestService = requestService;
    }

    public static boolean isAvailable() {
        return requestService != null;
    }

    public static void setOAuth(String string, AuthRequestEvent$OAuthRequestEvent authRequestEvent$OAuthRequestEvent) {
        oauth = authRequestEvent$OAuthRequestEvent;
        authId = string;
        tokenExpiredTime = oauth != null && Request.oauth.expire != 0L ? System.currentTimeMillis() + Request.oauth.expire : 0L;
        for (BiConsumer<String, AuthRequestEvent$OAuthRequestEvent> biConsumer : oauthChangeHandlers) {
            biConsumer.accept(string, authRequestEvent$OAuthRequestEvent);
        }
    }

    public static AuthRequestEvent$OAuthRequestEvent getOAuth() {
        return oauth;
    }

    public static String getAuthId() {
        return authId;
    }

    public static Map<String, Request$ExtendedToken> getExtendedTokens() {
        if (extendedTokens != null) {
            return Collections.unmodifiableMap(extendedTokens);
        }
        return null;
    }

    public static Map<String, String> getStringExtendedTokens() {
        if (extendedTokens != null) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (Map.Entry<String, Request$ExtendedToken> entry : extendedTokens.entrySet()) {
                hashMap.put(entry.getKey(), entry.getValue().token);
            }
            return hashMap;
        }
        return null;
    }

    public static void clearExtendedTokens() {
        if (extendedTokens != null) {
            extendedTokens.clear();
        }
    }

    public static void addExtendedToken(String string, Request$ExtendedToken request$ExtendedToken) {
        if (extendedTokens == null) {
            extendedTokens = new ConcurrentHashMap<String, Request$ExtendedToken>();
        }
        extendedTokens.put(string, request$ExtendedToken);
    }

    public static void addAllExtendedToken(Map<String, Request$ExtendedToken> map) {
        if (extendedTokens == null) {
            extendedTokens = new ConcurrentHashMap<String, Request$ExtendedToken>();
        }
        extendedTokens.putAll(map);
    }

    public static void setOAuth(String string, AuthRequestEvent$OAuthRequestEvent authRequestEvent$OAuthRequestEvent, long l) {
        oauth = authRequestEvent$OAuthRequestEvent;
        authId = string;
        tokenExpiredTime = l;
    }

    public static boolean isTokenExpired() {
        if (oauth == null) {
            return true;
        }
        if (tokenExpiredTime == 0L) {
            return false;
        }
        return System.currentTimeMillis() > tokenExpiredTime;
    }

    public static long getTokenExpiredTime() {
        return tokenExpiredTime;
    }

    public static String getAccessToken() {
        return oauth == null ? null : Request.oauth.accessToken;
    }

    public static String getRefreshToken() {
        return oauth == null ? null : Request.oauth.refreshToken;
    }

    public static void reconnect() {
        Request.getRequestService().open();
        Request.restore();
    }

    public static Request$RequestRestoreReport restore() {
        return Request.restore(false, false, false);
    }

    private static synchronized Map<String, String> getExpiredExtendedTokens() {
        if (extendedTokens == null) {
            return new HashMap<String, String>();
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (Map.Entry<String, Request$ExtendedToken> entry : extendedTokens.entrySet()) {
            if (entry.getValue().expire == 0L || entry.getValue().expire >= System.currentTimeMillis()) continue;
            hashSet.add(entry.getKey());
        }
        if (hashSet.isEmpty()) {
            return new HashMap<String, String>();
        }
        return Request.makeNewTokens(hashSet);
    }

    public static synchronized Request$RequestRestoreReport restore(boolean bl, boolean bl2, boolean bl3) {
        Object object;
        RequestEvent requestEvent;
        Request request;
        boolean bl4;
        block14: {
            bl4 = false;
            if (oauth != null && (Request.isTokenExpired() || Request.oauth.accessToken == null)) {
                if (bl3) {
                    oauth = null;
                } else {
                    request = new RefreshTokenRequest(authId, Request.oauth.refreshToken);
                    requestEvent = (RefreshTokenRequestEvent)request.request();
                    Request.setOAuth(authId, requestEvent.oauth);
                    bl4 = true;
                }
            }
            if (oauth != null) {
                if (bl2 && !bl4 && Request.getExpiredExtendedTokens().isEmpty()) {
                    return new Request$RequestRestoreReport(bl4, null, null);
                }
                if (bl4 || !bl2) {
                    request = new AuthRequest(null, new AuthOAuthPassword(Request.oauth.accessToken), authId, false, AuthRequest$ConnectTypes.CLIENT);
                    try {
                        requestEvent = (AuthRequestEvent)request.request();
                        Request.setOAuth(authId, ((AuthRequestEvent)requestEvent).oauth);
                        object = null;
                        if (((AuthRequestEvent)requestEvent).playerProfile != null) {
                            object = new CurrentUserRequestEvent$UserInfo();
                            ((CurrentUserRequestEvent$UserInfo)object).playerProfile = ((AuthRequestEvent)requestEvent).playerProfile;
                            ((CurrentUserRequestEvent$UserInfo)object).permissions = ((AuthRequestEvent)requestEvent).permissions;
                        }
                        if (Request.getExpiredExtendedTokens().isEmpty()) {
                            return new Request$RequestRestoreReport(bl4, null, (CurrentUserRequestEvent$UserInfo)object);
                        }
                    }
                    catch (Exception exception) {
                        if (Objects.equals(exception.getMessage(), "auth.invalidtoken") || Objects.equals(exception.getMessage(), "auth.expiretoken")) break block14;
                        throw exception;
                    }
                }
            }
        }
        request = oauth != null ? new RestoreRequest(authId, Request.oauth.accessToken, bl2 ? Request.getExpiredExtendedTokens() : Request.getStringExtendedTokens(), bl) : new RestoreRequest(authId, null, bl2 ? Request.getExpiredExtendedTokens() : Request.getStringExtendedTokens(), false);
        if (bl2 && (((RestoreRequest)request).extended == null || ((RestoreRequest)request).extended.isEmpty())) {
            return new Request$RequestRestoreReport(bl4, null, null);
        }
        requestEvent = (RestoreRequestEvent)request.request();
        object = null;
        if (((RestoreRequestEvent)requestEvent).invalidTokens != null && !((RestoreRequestEvent)requestEvent).invalidTokens.isEmpty()) {
            Map<String, String> map = Request.makeNewTokens(((RestoreRequestEvent)requestEvent).invalidTokens);
            if (!map.isEmpty()) {
                request = new RestoreRequest(authId, null, map, false);
                requestEvent = (RestoreRequestEvent)request.request();
                if (((RestoreRequestEvent)requestEvent).invalidTokens != null && !((RestoreRequestEvent)requestEvent).invalidTokens.isEmpty()) {
                    LogHelper.warning("Tokens %s not restored", String.join((CharSequence)",", ((RestoreRequestEvent)requestEvent).invalidTokens));
                }
            }
            object = ((RestoreRequestEvent)requestEvent).invalidTokens;
        }
        return new Request$RequestRestoreReport(bl4, (List<String>)object, ((RestoreRequestEvent)requestEvent).userInfo);
    }

    private static synchronized Map<String, String> makeNewTokens(Collection<String> collection) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (Request$ExtendedTokenCallback request$ExtendedTokenCallback : extendedTokenCallbacks) {
            for (String string : collection) {
                Request$ExtendedToken request$ExtendedToken = request$ExtendedTokenCallback.tryGetNewToken(string);
                if (request$ExtendedToken == null) continue;
                hashMap.put(string, request$ExtendedToken.token);
                Request.addExtendedToken(string, request$ExtendedToken);
            }
        }
        return hashMap;
    }

    public static void requestError(String string) {
        throw new RequestException(string);
    }

    public void addExtendedTokenCallback(Request$ExtendedTokenCallback request$ExtendedTokenCallback) {
        extendedTokenCallbacks.add(request$ExtendedTokenCallback);
    }

    public void removeExtendedTokenCallback(Request$ExtendedTokenCallback request$ExtendedTokenCallback) {
        extendedTokenCallbacks.remove(request$ExtendedTokenCallback);
    }

    public void addOAuthChangeHandler(BiConsumer<String, AuthRequestEvent$OAuthRequestEvent> biConsumer) {
        oauthChangeHandlers.add(biConsumer);
    }

    public void removeOAuthChangeHandler(BiConsumer<String, AuthRequestEvent$OAuthRequestEvent> biConsumer) {
        oauthChangeHandlers.remove(biConsumer);
    }

    public R request() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        if (!Request.isAvailable()) {
            throw new RequestException("RequestService not initialized");
        }
        return this.requestDo(requestService);
    }

    @Deprecated
    public R request(StdWebSocketService stdWebSocketService) {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        return this.requestDo(stdWebSocketService);
    }

    public R request(RequestService requestService) {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Request already started");
        }
        return this.requestDo(requestService);
    }

    protected R requestDo(RequestService requestService) {
        return (R)requestService.requestSync(this);
    }
}

