/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.util;

import java.io.Serializable;
import java.text.DecimalFormat;
import org.apache.logging.log4j.util.StringBuilderFormattable;
import org.apache.logging.log4j.util.Timer$1;
import org.apache.logging.log4j.util.Timer$Status;

public class Timer
implements Serializable,
StringBuilderFormattable {
    private static final long serialVersionUID = 9175191792439630013L;
    private final String name;
    private Timer$Status status;
    private long elapsedTime;
    private final int iterations;
    private static long NANO_PER_SECOND = 1000000000L;
    private static long NANO_PER_MINUTE = NANO_PER_SECOND * 60L;
    private static long NANO_PER_HOUR = NANO_PER_MINUTE * 60L;
    private ThreadLocal<Long> startTime = new Timer$1(this);

    public Timer(String string) {
        this(string, 0);
    }

    public Timer(String string, int n) {
        this.name = string;
        this.status = Timer$Status.Stopped;
        this.iterations = n > 0 ? n : 0;
    }

    public synchronized void start() {
        this.startTime.set(System.nanoTime());
        this.elapsedTime = 0L;
        this.status = Timer$Status.Started;
    }

    public synchronized void startOrResume() {
        if (this.status == Timer$Status.Stopped) {
            this.start();
        } else {
            this.resume();
        }
    }

    public synchronized String stop() {
        this.elapsedTime += System.nanoTime() - this.startTime.get();
        this.startTime.set(0L);
        this.status = Timer$Status.Stopped;
        return this.toString();
    }

    public synchronized void pause() {
        this.elapsedTime += System.nanoTime() - this.startTime.get();
        this.startTime.set(0L);
        this.status = Timer$Status.Paused;
    }

    public synchronized void resume() {
        this.startTime.set(System.nanoTime());
        this.status = Timer$Status.Started;
    }

    public String getName() {
        return this.name;
    }

    public long getElapsedTime() {
        return this.elapsedTime / 1000000L;
    }

    public long getElapsedNanoTime() {
        return this.elapsedTime;
    }

    public Timer$Status getStatus() {
        return this.status;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        this.formatTo(stringBuilder);
        return stringBuilder.toString();
    }

    @Override
    public void formatTo(StringBuilder stringBuilder) {
        stringBuilder.append("Timer ").append(this.name);
        switch (this.status) {
            case Started: {
                stringBuilder.append(" started");
                break;
            }
            case Paused: {
                stringBuilder.append(" paused");
                break;
            }
            case Stopped: {
                long l = this.elapsedTime;
                long l2 = l / NANO_PER_HOUR;
                long l3 = (l %= NANO_PER_HOUR) / NANO_PER_MINUTE;
                long l4 = (l %= NANO_PER_MINUTE) / NANO_PER_SECOND;
                l %= NANO_PER_SECOND;
                String string = "";
                if (l2 > 0L) {
                    string = string + l2 + " hours ";
                }
                if (l3 > 0L || l2 > 0L) {
                    string = string + l3 + " minutes ";
                }
                DecimalFormat decimalFormat = new DecimalFormat("#0");
                string = string + decimalFormat.format(l4) + '.';
                decimalFormat = new DecimalFormat("000000000");
                string = string + decimalFormat.format(l) + " seconds";
                stringBuilder.append(" stopped. Elapsed time: ").append(string);
                if (this.iterations <= 0) break;
                l = this.elapsedTime / (long)this.iterations;
                l2 = l / NANO_PER_HOUR;
                l3 = (l %= NANO_PER_HOUR) / NANO_PER_MINUTE;
                l4 = (l %= NANO_PER_MINUTE) / NANO_PER_SECOND;
                l %= NANO_PER_SECOND;
                string = "";
                if (l2 > 0L) {
                    string = string + l2 + " hours ";
                }
                if (l3 > 0L || l2 > 0L) {
                    string = string + l3 + " minutes ";
                }
                decimalFormat = new DecimalFormat("#0");
                string = string + decimalFormat.format(l4) + '.';
                decimalFormat = new DecimalFormat("000000000");
                string = string + decimalFormat.format(l) + " seconds";
                stringBuilder.append(" Average per iteration: ").append(string);
                break;
            }
            default: {
                stringBuilder.append(' ').append((Object)this.status);
            }
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Timer)) {
            return false;
        }
        Timer timer = (Timer)object;
        if (this.elapsedTime != timer.elapsedTime) {
            return false;
        }
        if (this.startTime != timer.startTime) {
            return false;
        }
        if (this.name != null ? !this.name.equals(timer.name) : timer.name != null) {
            return false;
        }
        return !(this.status != null ? !this.status.equals((Object)timer.status) : timer.status != null);
    }

    public int hashCode() {
        int n = this.name != null ? this.name.hashCode() : 0;
        n = 29 * n + (this.status != null ? this.status.hashCode() : 0);
        long l = this.startTime.get();
        n = 29 * n + (int)(l ^ l >>> 32);
        n = 29 * n + (int)(this.elapsedTime ^ this.elapsedTime >>> 32);
        return n;
    }
}

